/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.wildernature.registry.EntityRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniSheepEntity
extends Animal
implements Shearable {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MiniSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(MiniSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;
    private int eatAnimationTimeout = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState eatAnimationState = new AnimationState();

    public MiniSheepEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 80;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
            this.attackAnimationTimeout = 0;
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.eatAnimationTick > 0) {
            if (this.eatAnimationTimeout <= 0) {
                this.eatAnimationState.m_216977_(this.f_19797_);
                this.eatAnimationTimeout = 40;
            } else {
                --this.eatAnimationTimeout;
            }
        } else {
            this.eatAnimationState.m_216973_();
            this.eatAnimationTimeout = 0;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.eatAnimationTick > 0) {
            --this.eatAnimationTick;
            if (this.eatAnimationTick == 0) {
                this.eatAnimationState.m_216973_();
            }
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.eatAnimationTick = this.eatBlockGoal.m_25213_();
        if (this.eatAnimationTick > 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    protected void m_267689_(float v) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 1.25).m_22268_(Attributes.f_22283_, 0.1);
    }

    public void m_7822_(byte event) {
        if (event == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(event);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12341_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12343_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12342_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    @Nullable
    public MiniSheepEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (MiniSheepEntity)((EntityType)EntityRegistry.MINISHEEP.get()).m_20615_((Level)serverLevel);
    }

    public void m_8035_() {
        super.m_8035_();
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)10);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.95f * dimensions.f_20378_;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof ShearsItem && this.m_6220_()) {
            this.m_5851_(SoundSource.PLAYERS);
            itemstack.m_41622_(1, (LivingEntity)player, p_213613_1_ -> p_213613_1_.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(@NotNull SoundSource shearedSoundCategory) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)Items.f_41870_, 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setSheared(compoundTag.m_128471_("Sheared"));
    }
}

