/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoarEntity
extends Animal {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42579_, Items.f_42581_, Items.f_42732_, Items.f_42780_, Items.f_42620_, Items.f_42530_, Items.f_42531_, Items.f_42619_});
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int digAnimationTick;
    private DigIntoGrassGoal digintoBlockGoal;
    private boolean isDigging = false;

    public BoarEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.digintoBlockGoal = new DigIntoGrassGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42684_}), false));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)this.digintoBlockGoal);
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        this.digAnimationTick = this.digintoBlockGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public boolean isDigging() {
        return this.isDigging;
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.isDigging = true;
            this.digAnimationTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_ && this.digAnimationTick > 0) {
            --this.digAnimationTick;
            if (this.digAnimationTick == 0) {
                this.isDigging = false;
            }
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.2f : entityDimensions.f_20378_ * 0.3f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.BOAR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.BOAR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.BOAR_DEATH.get();
    }

    @Nullable
    public BoarEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (BoarEntity)((EntityType)EntityRegistry.BOAR.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6898_(@NotNull ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public class DigIntoGrassGoal
    extends Goal {
        private static final int EAT_ANIMATION_TICKS = 40;
        private static final BlockStatePredicate IS_GRASS_BLOCK = BlockStatePredicate.m_61287_((Block)Blocks.f_50440_);
        private final Mob mob;
        private final Level level;
        private int eatAnimationTick;

        public DigIntoGrassGoal(Mob mob) {
            this.mob = mob;
            this.level = mob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.mob.m_217043_().m_188503_(this.mob.m_6162_() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockPos = this.mob.m_20183_();
            return IS_GRASS_BLOCK.test(this.level.m_8055_(blockPos.m_7495_()));
        }

        public void m_8056_() {
            this.eatAnimationTick = this.m_183277_(40);
            this.level.m_7605_((Entity)this.mob, (byte)10);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.eatAnimationTick = 0;
        }

        public boolean m_8045_() {
            return this.eatAnimationTick > 0;
        }

        public int getEatAnimationTick() {
            return this.eatAnimationTick;
        }

        public void m_8037_() {
            BlockPos blockPos;
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == this.m_183277_(4) && IS_GRASS_BLOCK.test(this.level.m_8055_(blockPos = this.mob.m_20183_().m_7495_()))) {
                if (this.level.m_46469_().m_46207_(GameRules.f_46132_)) {
                    this.level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                    this.level.m_7731_(blockPos, Blocks.f_50546_.m_49966_(), 2);
                    this.spawnEatParticlesAndDrops((ServerLevel)this.level, blockPos);
                }
                this.mob.m_8035_();
            }
        }

        private void spawnEatParticlesAndDrops(ServerLevel serverLevel, BlockPos blockPos) {
            BlockState blockState = Blocks.f_50440_.m_49966_();
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, 10, 0.25, 0.25, 0.25, 0.5);
            Random random = new Random();
            int chance = random.nextInt(100);
            if (chance < 10) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.f_41952_));
            } else if (chance < 15) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.f_41953_));
            } else if (chance < 30) {
                this.spawnItem(serverLevel, blockPos, new ItemStack((ItemLike)Items.f_151017_));
            }
        }

        private void spawnItem(ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack) {
            Block.m_49840_((Level)serverLevel, (BlockPos)blockPos, (ItemStack)itemStack);
        }
    }
}

