/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BisonEntity
extends Animal
implements EntityWithAttackAnimation {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ROLLING = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> LAST_HURT_TIME = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public AnimationState rollingAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public BisonEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22283_, 1.25).m_22268_(Attributes.f_22279_, 0.18000099062919617).m_22268_(Attributes.f_22285_, 0.01777747832238674).m_22268_(Attributes.f_22282_, 2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.isAngry() && this.m_9236_().m_46467_() - this.getLastHurtTime() > 300L) {
            this.setAngry(false);
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        this.attackAnimationState.m_246184_(this.isAttacking(), this.f_19797_);
        this.rollingAnimationState.m_246184_(this.isRolling(), this.f_19797_);
    }

    private boolean isRolling() {
        return (Boolean)this.f_19804_.m_135370_(ROLLING);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.m_5448_();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.m_142593_(target);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.m_20318_((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.m_7327_((Entity)targetEntity);
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(ANGRY, (Object)angry);
    }

    public long getLastHurtTime() {
        return (Long)this.f_19804_.m_135370_(LAST_HURT_TIME);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ROLLING, (Object)false);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(ANGRY, (Object)false);
        this.f_19804_.m_135372_(LAST_HURT_TIME, (Object)0L);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.bison_attack * 20.0f), 5));
        this.f_21345_.m_25352_(1, (Goal)new BisonPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(9, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new BisonRollingGoal(this));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)EntityRegistry.BISON.get()).m_20615_((Level)pLevel);
    }

    protected SoundEvent m_7515_() {
        return this.isAngry() ? (SoundEvent)SoundRegistry.BISON_ANGRY.get() : (SoundEvent)SoundRegistry.BISON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.BISON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.BISON_DEATH.get();
    }

    public int m_8085_() {
        return 35;
    }

    public void setRolling(boolean rolling) {
        this.f_19804_.m_135381_(ROLLING, (Object)rolling);
    }

    static class BisonPanicGoal
    extends PanicGoal {
        public BisonPanicGoal(BisonEntity bison) {
            super((PathfinderMob)bison, 1.2);
        }

        public boolean m_8036_() {
            return this.f_25684_.m_6162_() && super.m_8036_();
        }
    }

    public static class BisonRollingGoal
    extends Goal {
        private final BisonEntity target;
        int counter;
        public static final AttributeModifier modifier = new AttributeModifier("bison_roll_do_not_move", -1000.0, AttributeModifier.Operation.ADDITION);

        public BisonRollingGoal(BisonEntity mob) {
            this.target = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            float r = new Random().nextFloat();
            return r < 0.001f && !this.target.isAngry();
        }

        public boolean m_8045_() {
            return this.counter > 0 && (float)this.counter < ServerAnimationDurations.bison_roll * 20.0f;
        }

        public void m_8037_() {
            ++this.counter;
        }

        public void m_8056_() {
            this.counter = 0;
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22118_(modifier);
            this.target.setRolling(true);
            super.m_8056_();
        }

        public void m_8041_() {
            Objects.requireNonNull(this.target.m_21051_(Attributes.f_22279_)).m_22130_(modifier);
            this.target.setRolling(false);
            super.m_8041_();
        }
    }
}

