/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.gui.screens;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledHeapByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.wildernature.client.gui.components.ContractButton;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.network.BountyBlockNetworking;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.Contract;

public class BountyBlockScreen
extends AbstractContainerScreen<BountyBlockScreenHandler> {
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 169;
    private static final WilderNatureIdentifier TEX_BACKGROUND = new WilderNatureIdentifier("textures/gui/bounty_board/background.png");
    private static final WilderNatureIdentifier TEX_REROLL = new WilderNatureIdentifier("textures/gui/bounty_board/reroll.png");
    private static final WilderNatureIdentifier TEX_DELETE = new WilderNatureIdentifier("textures/gui/bounty_board/delete.png");
    private static final WilderNatureIdentifier TEX_ACCEPT = new WilderNatureIdentifier("textures/gui/bounty_board/accept.png");
    private static final WilderNatureIdentifier TEX_FINISHEDSLOT = new WilderNatureIdentifier("textures/gui/bounty_board/finished_bg.png");
    private static final WilderNatureIdentifier TEX_BAR = new WilderNatureIdentifier("textures/gui/bounty_board/bar.png");
    private ImageButton rerollButton;
    private ImageButton acceptButton;
    private ImageButton finishButton;
    private ImageButton deleteButton;
    private final ContractButton[] contractButtons = new ContractButton[3];
    private ContractButton targetContractButton;

    public BountyBlockScreen(BountyBlockScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initializeButtons();
        this.initializeContractButtons();
        this.setupCallbacks();
    }

    private void initializeButtons() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.rerollButton = this.createImageButton(centerX - 74, centerY - 52, TEX_REROLL, this::onReroll);
        this.acceptButton = this.createImageButton(centerX - 88 + 135, centerY - 84 + 51, TEX_ACCEPT, this::onAccept);
        this.finishButton = this.createImageButton(centerX - 88 + 135, centerY - 84 + 51, TEX_ACCEPT, this::onFinish);
        this.finishButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.gui.wildernature.bounty.finish")));
        this.deleteButton = this.createImageButton(centerX - 58, centerY - 52, TEX_DELETE, this::onDeleteContract);
        this.deleteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.gui.wildernature.bounty.delete_contract")));
        this.m_142416_((GuiEventListener)this.rerollButton);
        this.m_142416_((GuiEventListener)this.acceptButton);
        this.m_142416_((GuiEventListener)this.finishButton);
        this.m_142416_((GuiEventListener)this.deleteButton);
    }

    private ImageButton createImageButton(int x, int y, WilderNatureIdentifier texture, Button.OnPress onPress) {
        return new ImageButton(x, y, 14, 14, 0, 0, 14, (ResourceLocation)texture, 14, 42, onPress);
    }

    private void initializeContractButtons() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.targetContractButton = new ContractButton(centerX - 88 + 97, centerY - 84 + 49, null, button -> {});
        for (int i = 0; i < 3; ++i) {
            Contract contract = ((BountyBlockScreenHandler)this.f_97732_).contracts[i];
            this.contractButtons[i] = (ContractButton)this.m_142416_((GuiEventListener)new ContractButton(centerX - 88 + 25 + i * 18, centerY - 84 + 49, contract, button -> this.setSelectedContract(((ContractButton)button).getContract())));
        }
        this.m_142416_((GuiEventListener)this.targetContractButton);
    }

    private void setupCallbacks() {
        ((BountyBlockScreenHandler)this.f_97732_).onContractUpdate.subscribe(() -> {
            this.targetContractButton.setContract(null);
            this.finishButton.f_93624_ = ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null && ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress.isFinished();
            for (int i = 0; i < 3; ++i) {
                this.contractButtons[i].setContract(((BountyBlockScreenHandler)this.f_97732_).contracts[i]);
            }
        });
        this.m_169394_((guiGraphics, mx, my, f) -> this.renderFinishedSlot(guiGraphics));
        this.m_169394_((guiGraphics, mx, my, f) -> this.renderWarningTooltip(guiGraphics));
        this.m_169394_((guiGraphics, i, j, f) -> this.renderProgressBar(guiGraphics));
    }

    private void renderFinishedSlot(GuiGraphics guiGraphics) {
        if (((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null && ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress.isFinished()) {
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            int alpha = 128;
            int color = FastColor.ARGB32.m_13660_((int)alpha, (int)255, (int)255, (int)255);
            guiGraphics.m_280398_((ResourceLocation)TEX_FINISHEDSLOT, centerX - 88 + 95, centerY - 84 + 47, 0, 0.0f, 22.0f, 22, 22, 22, color);
        }
    }

    private void renderWarningTooltip(GuiGraphics guiGraphics) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int xPos = centerX + 88 - 4;
        int yPos = centerY - 84 + 29;
        if (((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null && ((BountyBlockScreenHandler)this.f_97732_).boardId != ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress.boardId) {
            int tooltipTextWidth = 111;
            assert (this.f_96541_ != null);
            List tip = this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"text.gui.wildernature.bounty.finish.warning"), tooltipTextWidth);
            guiGraphics.m_280245_(this.f_96541_.f_91062_, tip, xPos, yPos);
        }
    }

    private void renderProgressBar(GuiGraphics guiGraphics) {
        int guiX = this.f_96543_ / 2 - 88;
        int guiY = this.f_96544_ / 2 - 84;
        guiGraphics.m_280163_((ResourceLocation)TEX_BAR, guiX + 12, guiY + 11, 0.0f, 0.0f, (int)(153.0f * ((BountyBlockScreenHandler)this.f_97732_).progress), 5, 153, 5);
    }

    private void onAccept(Button button) {
        for (int i = 0; i < 3; ++i) {
            if (this.contractButtons[i].getContract() != this.targetContractButton.getContract()) continue;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130068_((Enum)BountyBlockNetworking.BountyClientActionType.CONFIRM_CONTRACT);
            buf.writeByte(i);
            NetworkManager.sendToServer((ResourceLocation)BountyBlockNetworking.ID_SCREEN_ACTION, (FriendlyByteBuf)buf);
            this.contractButtons[i].setContract(null);
            this.contractButtons[i].f_93623_ = false;
            return;
        }
        throw new RuntimeException("No Contract Found");
    }

    private void setSelectedContract(Contract contract) {
        this.targetContractButton.setContractSelected(contract, true);
    }

    private void onReroll(Button button) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130068_((Enum)BountyBlockNetworking.BountyClientActionType.REROLL);
        NetworkManager.sendToServer((ResourceLocation)BountyBlockNetworking.ID_SCREEN_ACTION, (FriendlyByteBuf)buf);
    }

    private void onDeleteContract(Button button) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130068_((Enum)BountyBlockNetworking.BountyClientActionType.DELETE_CONTRACT);
        NetworkManager.sendToServer((ResourceLocation)BountyBlockNetworking.ID_SCREEN_ACTION, (FriendlyByteBuf)buf);
    }

    private void onFinish(Button button) {
        FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
        buf.m_130068_((Enum)BountyBlockNetworking.BountyClientActionType.FINISH_CONTRACT);
        NetworkManager.sendToServer((ResourceLocation)BountyBlockNetworking.ID_SCREEN_ACTION, (FriendlyByteBuf)buf);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mx, int my, float f) {
        if (((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null) {
            this.targetContractButton.setContractProgress(((BountyBlockScreenHandler)this.f_97732_).activeContract, ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress);
            if (!((BountyBlockScreenHandler)this.f_97732_).activeContractProgress.isFinished()) {
                this.targetContractButton.setContract(null);
            }
        }
        if (((BountyBlockScreenHandler)this.f_97732_).activeContractProgress == null && this.targetContractButton.progress != null) {
            this.targetContractButton.setContract(null);
        }
        this.finishButton.f_93624_ = ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null && ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress.isFinished();
        this.updateTooltip();
        this.acceptButton.f_93624_ = ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress == null && this.targetContractButton != null && this.targetContractButton.getContract() != null;
        this.acceptButton.f_93623_ = ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress == null;
        this.deleteButton.f_93624_ = ((BountyBlockScreenHandler)this.f_97732_).activeContractProgress != null;
        super.m_88315_(guiGraphics, mx, my, f);
        this.m_280072_(guiGraphics, mx, my);
    }

    private void updateTooltip() {
        MutableComponent comp = Component.m_237110_((String)"text.gui.wildernature.bounty.reroll.left", (Object[])new Object[]{((BountyBlockScreenHandler)this.f_97732_).rerolls});
        if (((BountyBlockScreenHandler)this.f_97732_).time > 0) {
            comp = comp.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"text.gui.wildernature.bounty.reroll.time", (Object[])new Object[]{((BountyBlockScreenHandler)this.f_97732_).time / 20 / 60, ((BountyBlockScreenHandler)this.f_97732_).time / 20 % 60}));
        }
        Tooltip tooltip = Tooltip.m_257550_((Component)comp);
        this.rerollButton.m_257544_(tooltip);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, FastColor.ARGB32.m_13660_((int)64, (int)0, (int)0, (int)0));
        guiGraphics.m_280218_((ResourceLocation)TEX_BACKGROUND, this.f_96543_ / 2 - 88, this.f_96544_ / 2 - 84, 0, 0, 176, 169);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
    }
}

