/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import net.satisfy.meadow.core.block.StoveBlockBench;
import net.satisfy.meadow.core.block.StoveBlockSmoker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlockMain
extends FacingBlock {
    public static final BooleanProperty CONNECTED_UP = BooleanProperty.m_61465_((String)"connected_up");
    public static final BooleanProperty CONNECTED_DOWN = BooleanProperty.m_61465_((String)"connected_down");
    public static final VoxelShape SHAPE_BIG = Shapes.m_83110_((VoxelShape)StoveBlockBench.SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public StoveBlockMain(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)CONNECTED_DOWN)).booleanValue()) {
            return super.m_5940_(state, world, pos, context);
        }
        return SHAPE_BIG;
    }

    public boolean isConnected(BlockState state, Direction direction) {
        return (Boolean)state.m_61143_((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean up = this.isBlockStove(ctx, Direction.UP);
        boolean down = this.isBlockStove(ctx, Direction.DOWN);
        if (up || down) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        }
        return super.m_5573_(ctx);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!(world.m_5776_() || direction != Direction.DOWN && direction != Direction.UP)) {
            if (!this.isConnected(state, direction)) {
                if (this.isBlockStove(neighborState)) {
                    return (BlockState)state.m_61124_((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN), (Comparable)Boolean.valueOf(true));
                }
            } else if (!this.isBlockStove(neighborState)) {
                return (BlockState)state.m_61124_((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN), (Comparable)Boolean.valueOf(false));
            }
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED_DOWN});
        builder.m_61104_(new Property[]{CONNECTED_UP});
    }

    public boolean isBlockStove(BlockPlaceContext ctx, Direction direction) {
        return this.isBlockStove(ctx.m_43725_().m_8055_(ctx.m_8083_().m_121945_(direction)));
    }

    public boolean isBlockStove(BlockState blockState) {
        return this.isBlockStove(blockState.m_60734_());
    }

    public boolean isBlockStove(Block block) {
        return block instanceof StoveBlockSmoker || block instanceof StoveBlockMain;
    }
}

