/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.item.WoodenBucket;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CanBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.921875, (double)0.28125, (double)0.375, (double)0.984375, (double)0.28125, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.984375, (double)0.28125, (double)0.375, (double)1.046875, (double)0.28125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.921875, (double)0.28125, (double)0.5625, (double)0.984375, (double)0.28125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.0625, (double)0.65625, (double)0.375, (double)0.0, (double)0.65625, (double)0.4375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.125, (double)0.65625, (double)0.375, (double)-0.0625, (double)0.65625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.0625, (double)0.65625, (double)0.5625, (double)0.0, (double)0.65625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.875, (double)0.625, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.875, (double)0.25, (double)0.75, (double)0.9375, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.625, (double)0.3125, (double)0.375, (double)0.875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.625, (double)0.3125, (double)0.6875, (double)0.875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.625, (double)0.3125, (double)0.625, (double)0.875, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.625, (double)0.625, (double)0.625, (double)0.875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.875, (double)0.375, (double)0.375, (double)0.9375, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.875, (double)0.375, (double)0.75, (double)0.9375, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });
    public static final IntegerProperty FLUID = IntegerProperty.m_61631_((String)"fluid", (int)0, (int)2);

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public CanBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FLUID, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean milk;
        boolean water;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!(item instanceof BucketItem || item instanceof MilkBucketItem || item instanceof WoodenBucket)) {
            return InteractionResult.PASS;
        }
        boolean wood = this.isWooden(item);
        if ((Integer)state.m_61143_((Property)FLUID) == 0 && ((water = this.isWater(item)) || (milk = this.isMilk(item)))) {
            if (!world.m_5776_()) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)(wood ? (ItemLike)ObjectRegistry.WOODEN_BUCKET.get() : Items.f_42446_))));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)FLUID, (Comparable)Integer.valueOf(water ? 2 : 1)));
                world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (((Integer)state.m_61143_((Property)FLUID) == 1 || (Integer)state.m_61143_((Property)FLUID) == 2) && (item.equals(Items.f_42446_) || item.equals(ObjectRegistry.WOODEN_BUCKET.get()))) {
            if (!world.m_5776_()) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)((Integer)state.m_61143_((Property)FLUID) == 2 ? (wood ? (ItemLike)ObjectRegistry.WOODEN_WATER_BUCKET.get() : Items.f_42447_) : (wood ? (ItemLike)ObjectRegistry.WOODEN_MILK_BUCKET.get() : Items.f_42455_)))));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)FLUID, (Comparable)Integer.valueOf(0)));
                world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public boolean isMilk(Item item) {
        return item.equals(Items.f_42455_) || item.equals(ObjectRegistry.WOODEN_MILK_BUCKET.get());
    }

    public boolean isWooden(Item item) {
        return item.equals(ObjectRegistry.WOODEN_WATER_BUCKET.get()) || item.equals(ObjectRegistry.WOODEN_MILK_BUCKET.get()) || item.equals(ObjectRegistry.WOODEN_BUCKET.get());
    }

    public boolean isWater(Item item) {
        return item.equals(Items.f_42447_) || item.equals(ObjectRegistry.WOODEN_WATER_BUCKET.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FLUID, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

