/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.meadow.client.gui.CheeseFormGui;
import net.satisfy.meadow.client.gui.CookingCauldronGui;
import net.satisfy.meadow.client.gui.WoodcutterGui;
import net.satisfy.meadow.client.model.FurBootsModel;
import net.satisfy.meadow.client.model.FurChestplateModel;
import net.satisfy.meadow.client.model.FurHelmetModel;
import net.satisfy.meadow.client.model.FurLeggingsModel;
import net.satisfy.meadow.client.model.WaterBuffaloModel;
import net.satisfy.meadow.client.model.WoolyCowModel;
import net.satisfy.meadow.client.model.WoolySheepFurModel;
import net.satisfy.meadow.client.model.WoolySheepModel;
import net.satisfy.meadow.client.renderer.block.CompletionistBannerRenderer;
import net.satisfy.meadow.client.renderer.block.ModHangingSignRenderer;
import net.satisfy.meadow.client.renderer.block.ModSignRenderer;
import net.satisfy.meadow.client.renderer.block.storage.CheeseRackRenderer;
import net.satisfy.meadow.client.renderer.block.storage.FlowerBoxRenderer;
import net.satisfy.meadow.client.renderer.block.storage.FlowerPotBigRenderer;
import net.satisfy.meadow.client.renderer.block.storage.FlowerPotSmallRenderer;
import net.satisfy.meadow.client.renderer.block.storage.StorageBlockEntityRenderer;
import net.satisfy.meadow.client.renderer.block.storage.WheelBarrowRenderer;
import net.satisfy.meadow.client.renderer.entity.ChairRenderer;
import net.satisfy.meadow.client.renderer.entity.PineBoatRenderer;
import net.satisfy.meadow.client.renderer.entity.WaterBuffaloRenderer;
import net.satisfy.meadow.client.renderer.entity.WoolyCowRenderer;
import net.satisfy.meadow.client.renderer.entity.WoolySheepRenderer;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.core.registry.StorageTypeRegistry;

public class MeadowClient {
    public static final ModelLayerLocation SHEARABLE_MEADOW_COW_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "shearable_meadow_cow"), "head");
    public static final ModelLayerLocation WATER_BUFFALO_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "water_buffalo"), "head");
    public static final ModelLayerLocation MEADOW_SHEEP_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "meadow_sheep"), "main");
    public static final ModelLayerLocation MEADOW_SHEEP_FUR_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("meadow", "meadow_sheep_fur"), "main");

    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.PINE_DOOR.get(), (Block)ObjectRegistry.PINE_TRAPDOOR.get(), (Block)ObjectRegistry.DELPHINIUM.get(), (Block)ObjectRegistry.ALPINE_POPPY.get(), (Block)ObjectRegistry.SAXIFRAGE.get(), (Block)ObjectRegistry.ENZIAN.get(), (Block)ObjectRegistry.COOKING_CAULDRON.get(), (Block)ObjectRegistry.FRAME.get(), (Block)ObjectRegistry.TABLE.get(), (Block)ObjectRegistry.FIRE_LOG.get(), (Block)ObjectRegistry.ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.SMALL_FIR.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.CHAIR.get(), (Block)ObjectRegistry.POTTED_DELPHINIUM.get(), (Block)ObjectRegistry.POTTED_ALPINE_POPPY.get(), (Block)ObjectRegistry.POTTED_SAXIFRAGE.get(), (Block)ObjectRegistry.POTTED_ENZIAN.get(), (Block)ObjectRegistry.POTTED_ERIOPHORUM.get(), (Block)ObjectRegistry.ERIOPHORUM_TALL.get(), (Block)ObjectRegistry.PINE_SAPLING.get(), (Block)ObjectRegistry.POTTED_PINE_SAPLING.get(), (Block)ObjectRegistry.FIRE_LILY.get(), (Block)ObjectRegistry.POTTED_FIRE_LILY.get(), (Block)ObjectRegistry.WOODEN_FLOWER_POT_SMALL.get(), (Block)ObjectRegistry.FONDUE.get(), (Block)ObjectRegistry.OIL_LANTERN.get(), (Block)ObjectRegistry.WHEELBARROW.get(), (Block)ObjectRegistry.PINE_LEAVES_2.get(), (Block)ObjectRegistry.WOODEN_FLOWER_POT_BIG.get(), (Block)ObjectRegistry.WOODCUTTER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)ObjectRegistry.HEART_PATTERNED_WINDOW.get(), (Block)ObjectRegistry.SUN_PATTERNED_WINDOW.get(), (Block)ObjectRegistry.PINE_WINDOW.get()});
        MeadowClient.registerStorageTypeRenderers();
        MeadowClient.registerClientScreens();
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_WATER_CAULDRON, ObjectRegistry.WATERING_CAN});
        MeadowClient.registerBlockEntityRenderer();
    }

    public static void preInitClient() {
        MeadowClient.registerEntityRenderers();
        MeadowClient.registerEntityModelLayers();
    }

    public static void registerStorageTypeRenderers() {
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.WHEEL_BARROW, new WheelBarrowRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.FLOWER_BOX, new FlowerBoxRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.FLOWER_POT_SMALL, new FlowerPotSmallRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.FLOWER_POT_BIG, new FlowerPotBigRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.CHEESE_RACK, new CheeseRackRenderer());
    }

    private static void registerClientScreens() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get()), CheeseFormGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get()), CookingCauldronGui::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlerRegistry.WOODCUTTER_SCREEN_HANDLER.get()), WoodcutterGui::new);
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.MEADOW_BANNER.get()), CompletionistBannerRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get()), context -> new StorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.MOD_SIGN.get()), ModSignRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.MOD_HANGING_SIGN.get()), ModHangingSignRenderer::new);
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.CHAIR, ChairRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.WOOLY_COW, WoolyCowRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.WATER_BUFFALO, WaterBuffaloRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.PINE_BOAT, context -> new PineBoatRenderer(context, false));
        EntityRendererRegistry.register(EntityTypeRegistry.PINE_CHEST_BOAT, context -> new PineBoatRenderer(context, true));
        EntityRendererRegistry.register(EntityTypeRegistry.WOOLY_SHEEP, WoolySheepRenderer::new);
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)FurHelmetModel.LAYER_LOCATION, FurHelmetModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)FurChestplateModel.LAYER_LOCATION, FurChestplateModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)FurLeggingsModel.LAYER_LOCATION, FurLeggingsModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)FurBootsModel.LAYER_LOCATION, FurBootsModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CompletionistBannerRenderer.LAYER_LOCATION, CompletionistBannerRenderer::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SHEARABLE_MEADOW_COW_MODEL_LAYER, WoolyCowModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WATER_BUFFALO_MODEL_LAYER, WaterBuffaloModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)MEADOW_SHEEP_MODEL_LAYER, WoolySheepModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)MEADOW_SHEEP_FUR_MODEL_LAYER, WoolySheepFurModel::createBodyLayer);
    }
}

