/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.farm_and_charm.core.block.entity.StorageBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.entity.ai.ChickenGotoAndEnterCoopGoal;
import net.satisfy.farm_and_charm.core.entity.ai.ChickenLocateCoopGoal;
import net.satisfy.farm_and_charm.core.mixin.MobAccessor;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chicken.class})
public class ChickenMixin
implements ChickenCoopAccess {
    @Unique
    private BlockPos farmAndCharm$coopTarget;
    @Unique
    private boolean farmAndCharm$searchedForCoop = false;
    @Unique
    private int farmAndCharm$coopCooldown = 0;

    @Override
    public BlockPos farmAndCharm$getCoopTarget() {
        return this.farmAndCharm$coopTarget;
    }

    @Override
    public void farmAndCharm$setCoopTarget(BlockPos pos) {
        this.farmAndCharm$coopTarget = pos;
    }

    @Override
    public void farmAndCharm$clearCoopTarget() {
        this.farmAndCharm$coopTarget = null;
    }

    @Override
    public boolean farmAndCharm$searchedForCoop() {
        return this.farmAndCharm$searchedForCoop;
    }

    @Override
    public boolean farmAndCharm$hasCoopTarget() {
        return this.farmAndCharm$coopTarget != null;
    }

    @Override
    public void farmAndCharm$setSearchedForCoop(boolean value) {
        this.farmAndCharm$searchedForCoop = value;
    }

    @Override
    public int farmAndCharm$getCoopCooldown() {
        return this.farmAndCharm$coopCooldown;
    }

    @Override
    public void farmAndCharm$setCoopCooldown(int cooldown) {
        this.farmAndCharm$coopCooldown = cooldown;
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void farmAndCharm$tickCoopCooldown(CallbackInfo ci) {
        if (this.farmAndCharm$coopCooldown > 0) {
            --this.farmAndCharm$coopCooldown;
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void addCustomGoals(CallbackInfo ci) {
        Chicken chicken = (Chicken)this;
        GoalSelector goalSelector = ((MobAccessor)chicken).farmAndCharm$getGoalSelector();
        goalSelector.m_25352_(8, (Goal)new ChickenLocateCoopGoal(chicken));
        goalSelector.m_25352_(9, (Goal)new ChickenGotoAndEnterCoopGoal(chicken));
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Chicken;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;"))
    private ItemEntity redirectEggLaying(Chicken instance, ItemLike item) {
        if (!item.equals((Object)Items.f_42521_)) {
            return instance.m_19998_(item);
        }
        Level level = instance.m_9236_();
        if (level.m_5776_() || instance.m_6162_() || !instance.m_6084_() || instance.m_28264_()) {
            return instance.m_19998_(item);
        }
        BlockPos origin = instance.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-6, -2, -6), (BlockPos)origin.m_7918_(6, 2, 6))) {
            BlockEntity be;
            if (!level.m_8055_(pos).m_60713_((Block)ObjectRegistry.CHICKEN_NEST.get()) || !((be = level.m_7702_(pos)) instanceof StorageBlockEntity)) continue;
            StorageBlockEntity storage = (StorageBlockEntity)be;
            for (int i = 0; i < storage.getInventory().size(); ++i) {
                if (!((ItemStack)storage.getInventory().get(i)).m_41619_()) continue;
                storage.getInventory().set(i, (Object)new ItemStack((ItemLike)Items.f_42521_));
                storage.m_6596_();
                level.m_46745_(pos).m_8092_(true);
                level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
                instance.m_146850_(GameEvent.f_157810_);
                return null;
            }
        }
        return instance.m_19998_(item);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void farmAndCharm$saveCoopData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("CoopCooldown", this.farmAndCharm$coopCooldown);
        tag.m_128379_("SearchedForCoop", this.farmAndCharm$searchedForCoop);
        if (this.farmAndCharm$coopTarget != null) {
            tag.m_128405_("CoopTargetX", this.farmAndCharm$coopTarget.m_123341_());
            tag.m_128405_("CoopTargetY", this.farmAndCharm$coopTarget.m_123342_());
            tag.m_128405_("CoopTargetZ", this.farmAndCharm$coopTarget.m_123343_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void farmAndCharm$loadCoopData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("CoopCooldown")) {
            this.farmAndCharm$coopCooldown = tag.m_128451_("CoopCooldown");
        }
        if (tag.m_128441_("SearchedForCoop")) {
            this.farmAndCharm$searchedForCoop = tag.m_128471_("SearchedForCoop");
        }
        if (tag.m_128441_("CoopTargetX") && tag.m_128441_("CoopTargetY") && tag.m_128441_("CoopTargetZ")) {
            int x = tag.m_128451_("CoopTargetX");
            int y = tag.m_128451_("CoopTargetY");
            int z = tag.m_128451_("CoopTargetZ");
            this.farmAndCharm$coopTarget = new BlockPos(x, y, z);
        }
    }
}

