/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class WhineAtBowlGoal
extends Goal {
    private final Wolf wolf;
    private BlockPos bowlPos;
    private Vec3 lastTargetPos;
    private int whineTicks;
    private int fadeOutTicks;
    private long lastScanTick;
    private long lastWhineSoundTick;
    private boolean active;
    private static final int SCAN_INTERVAL_TICKS = 40;
    private static final int MAX_WHINE_TICKS = 300;
    private static final int WHINE_INTERVAL = 60;
    private static final int ANGRY_PARTICLE_INTERVAL = 100;
    private static final int WHINE_PARTICLE_COUNT = 6;
    private static final int FINAL_PARTICLE_COUNT = 15;
    private static final int FADE_OUT_DURATION = 30;
    private static final double BASE_SPEED = 1.0;
    private static final double EVENING_SPEED_FACTOR = 0.8;
    private static final double CLOSE_ENOUGH_DIST = 1.1;
    private static final float BASE_VOLUME = 0.4f;
    private static final float BASE_PITCH = 0.4f;
    private static final int LOOK_YAW = 10;
    private static final int LOOK_PITCH = 30;
    private static final int RANGE_XZ = 10;
    private static final int RANGE_Y = 2;
    private static final long MORNING_START = 5800L;
    private static final long MORNING_END = 6200L;
    private static final long EVENING_START = 11500L;
    private static final long EVENING_END = 12500L;
    private static final double NAVIGATION_RECALC_THRESHOLD_SQR = 0.5;
    private static final List<SoundEvent> WHINE_SOUNDS = List.of(SoundEvents.f_12625_, SoundEvents.f_12622_);

    public WhineAtBowlGoal(Wolf wolf) {
        this.wolf = wolf;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.whineTicks = 0;
        this.lastScanTick = -40L;
        this.lastWhineSoundTick = -60L;
        this.active = false;
        this.lastTargetPos = null;
    }

    public boolean m_8036_() {
        if (!this.wolf.m_6084_() || !this.wolf.m_21824_() || this.wolf.m_21827_()) {
            return false;
        }
        Level level = this.wolf.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        if (!this.shouldScanForBowl(server.m_46467_())) {
            return false;
        }
        if (!this.isValidWhineTime(server.m_46468_())) {
            return false;
        }
        BlockPos wolfPos = this.wolf.m_20183_();
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)wolfPos.m_7918_(-10, -2, -10), (BlockPos)wolfPos.m_7918_(10, 2, 10))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            if (!this.wolf.m_9236_().m_8055_(pos).m_60713_((Block)ObjectRegistry.PET_BOWL.get()) || !((be = this.wolf.m_9236_().m_7702_(pos)) instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).m_7983_() || !bowl.canBeUsedBy((Animal)this.wolf) || !((dist = this.wolf.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)pos))) < closestDistance)) continue;
            closestDistance = dist;
            closest = pos.m_7949_();
        }
        if (closest != null) {
            this.bowlPos = closest;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        PetBowlBlockEntity bowl;
        if (!this.active || !this.wolf.m_6084_() || this.bowlPos == null) {
            return false;
        }
        Level level = this.wolf.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.m_7702_(this.bowlPos);
        return be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).m_7983_() && bowl.canBeUsedBy((Animal)this.wolf);
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        PetBowlBlockEntity bowl;
        Level level = this.wolf.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.m_7702_(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity && (bowl = (PetBowlBlockEntity)be).m_7983_() && bowl.canBeUsedBy((Animal)this.wolf))) {
            this.m_8041_();
            return;
        }
        this.wolf.m_21839_(false);
        this.moveToBowl(server.m_46468_());
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.lastWhineSoundTick = -60L;
        this.active = true;
    }

    public void m_8037_() {
        LivingEntity owner;
        PetBowlBlockEntity bowl;
        ServerLevel server;
        block17: {
            block16: {
                Level level = this.wolf.m_9236_();
                if (!(level instanceof ServerLevel)) break block16;
                server = (ServerLevel)level;
                if (this.wolf.m_6084_()) break block17;
            }
            this.m_8041_();
            return;
        }
        BlockEntity be = server.m_7702_(this.bowlPos);
        if (!(be instanceof PetBowlBlockEntity) || !(bowl = (PetBowlBlockEntity)be).m_7983_()) {
            this.m_8041_();
            return;
        }
        Vec3 bowlCenter = Vec3.m_82512_((Vec3i)this.bowlPos);
        if (this.isNearBowl()) {
            if (this.wolf.m_21573_().m_26572_()) {
                this.wolf.m_21573_().m_26573_();
            }
            if (!this.wolf.m_21825_()) {
                this.wolf.m_21839_(true);
            }
            this.wolf.m_21563_().m_24950_(bowlCenter.f_82479_, bowlCenter.f_82480_, bowlCenter.f_82481_, 10.0f, 30.0f);
        } else {
            if (this.wolf.m_21825_()) {
                this.wolf.m_21839_(false);
            }
            if (!this.wolf.m_21573_().m_26572_() || this.needsRepath(bowlCenter)) {
                this.moveToBowl(server.m_46468_());
            }
        }
        if ((long)this.whineTicks - this.lastWhineSoundTick >= 60L) {
            this.playWhineSound();
            this.lastWhineSoundTick = this.whineTicks;
        }
        if (this.whineTicks % 100 == 0) {
            Vec3 pos = this.wolf.m_20182_().m_82520_(0.0, 0.5, 0.0);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 6, 0.3, 0.3, 0.3, 0.01);
        }
        if ((owner = this.wolf.m_269323_()) != null && (double)this.wolf.m_20270_((Entity)owner) < 4.0 && server.m_213780_().m_188503_(100) < 10) {
            this.wolf.m_5496_(SoundEvents.f_12625_, 0.6f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
        }
        if (++this.whineTicks >= 300) {
            PetBowlBlockEntity finalBowl;
            if (this.fadeOutTicks < 30) {
                ++this.fadeOutTicks;
                return;
            }
            BlockEntity currentBowl = server.m_7702_(this.bowlPos);
            if (currentBowl instanceof PetBowlBlockEntity && (finalBowl = (PetBowlBlockEntity)currentBowl).m_7983_()) {
                this.wolf.m_5496_(SoundEvents.f_12619_, 0.4f, 0.4f);
                Vec3 pos = this.wolf.m_20182_().m_82520_(0.0, 0.5, 0.0);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 15, 0.3, 0.3, 0.3, 0.01);
            }
            this.m_8041_();
        }
    }

    public void m_8041_() {
        this.bowlPos = null;
        this.whineTicks = 0;
        this.fadeOutTicks = 0;
        this.active = false;
        this.lastTargetPos = null;
        this.wolf.m_21839_(false);
        if (this.wolf.m_21573_().m_26572_()) {
            this.wolf.m_21573_().m_26573_();
        }
    }

    private void playWhineSound() {
        SoundEvent sound = WHINE_SOUNDS.get(this.wolf.m_217043_().m_188503_(WHINE_SOUNDS.size()));
        float volume = 0.4f + this.wolf.m_217043_().m_188501_() * 0.3f;
        float pitch = 0.4f + this.wolf.m_217043_().m_188501_() * 0.4f;
        this.wolf.m_5496_(sound, volume, pitch);
    }

    private boolean isNearBowl() {
        return this.bowlPos != null && this.wolf.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.bowlPos)) < 1.2100000000000002;
    }

    private boolean shouldScanForBowl(long currentTick) {
        if (currentTick - this.lastScanTick < 40L) {
            return false;
        }
        this.lastScanTick = currentTick;
        return true;
    }

    private boolean isValidWhineTime(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        return dayTime >= 5800L && dayTime <= 6200L || dayTime >= 11500L && dayTime <= 12500L;
    }

    private void moveToBowl(long timeOfDay) {
        if (this.bowlPos != null) {
            Vec3 target = Vec3.m_82512_((Vec3i)this.bowlPos);
            this.wolf.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, this.getSpeed(timeOfDay));
            this.lastTargetPos = target;
        }
    }

    private boolean needsRepath(Vec3 target) {
        return this.lastTargetPos == null || this.lastTargetPos.m_82557_(target) > 0.5;
    }

    private double getSpeed(long timeOfDay) {
        long dayTime = timeOfDay % 24000L;
        if (dayTime >= 11500L && dayTime <= 12500L) {
            return 0.8;
        }
        return 1.0;
    }
}

