/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.client.FarmAndCharmClient;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PetBowlBlock
extends FacingBlock
implements EntityBlock {
    public static final EnumProperty<GeneralUtil.FoodType> FOOD_TYPE = EnumProperty.m_61587_((String)"food_type", GeneralUtil.FoodType.class);
    public static final BooleanProperty HAS_NAME_TAG = BooleanProperty.m_61465_((String)"has_name_tag");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    public static final Map<Direction, VoxelShape> SHAPE = new HashMap<Direction, VoxelShape>();

    public PetBowlBlock(BlockBehaviour.Properties properties) {
        super(properties.m_284180_(MapColor.f_283748_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(FOOD_TYPE, (Comparable)((Object)GeneralUtil.FoodType.NONE))).m_61124_((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FOOD_TYPE, HAS_NAME_TAG});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        GeneralUtil.FoodType type;
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PetBowlBlockEntity)) {
            return InteractionResult.PASS;
        }
        PetBowlBlockEntity entity = (PetBowlBlockEntity)blockEntity;
        if (heldItem.m_150930_(Items.f_42574_) && ((Boolean)state.m_61143_((Property)HAS_NAME_TAG)).booleanValue()) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(false)), 3);
                PetBowlBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42656_));
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_150930_(Items.f_42656_) && !((Boolean)state.m_61143_((Property)HAS_NAME_TAG)).booleanValue()) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)HAS_NAME_TAG)).booleanValue() && player.m_6144_()) {
            if (level.f_46443_) {
                FarmAndCharmClient.openPetBowlScreen(entity);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND && state.m_61143_(FOOD_TYPE) == GeneralUtil.FoodType.NONE && (type = this.getFoodType(heldItem)) != GeneralUtil.FoodType.NONE) {
            level.m_7731_(pos, (BlockState)state.m_61124_(FOOD_TYPE, (Comparable)((Object)type)), 3);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            entity.m_6836_(0, new ItemStack((ItemLike)heldItem.m_41720_()));
            entity.onFed(heldItem);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private GeneralUtil.FoodType getFoodType(ItemStack stack) {
        if (stack.m_150930_((Item)ObjectRegistry.CAT_FOOD.get())) {
            return GeneralUtil.FoodType.CAT;
        }
        if (stack.m_150930_((Item)ObjectRegistry.DOG_FOOD.get())) {
            return GeneralUtil.FoodType.DOG;
        }
        return GeneralUtil.FoodType.NONE;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PetBowlBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    static {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPE.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    }
}

