/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.StorageBlock;
import net.satisfy.candlelight.core.block.entity.StorageBlockEntity;
import net.satisfy.candlelight.core.block.entity.TableSetBlockEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class TableSetBlock
extends StorageBlock {
    public static final EnumProperty<PlateType> PLATE_TYPE = EnumProperty.m_61587_((String)"plate_tye", PlateType.class);
    public static final BooleanProperty WINE_GLASS = BooleanProperty.m_61465_((String)"wine_glass");
    public static final BooleanProperty GLASS = BooleanProperty.m_61465_((String)"glass");
    public static final BooleanProperty CLOCHE = BooleanProperty.m_61465_((String)"cloche");
    public static final BooleanProperty NAPKIN = BooleanProperty.m_61465_((String)"napkin");
    public static final BooleanProperty GLASS_DRINK = BooleanProperty.m_61465_((String)"glass_drink");
    public static final BooleanProperty WINE_GLASS_DRINK = BooleanProperty.m_61465_((String)"wine_glass_drink");
    private static final TagKey<Item> ALL_EFFECTS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("candlelight", "all_effects"));

    public TableSetBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)WINE_GLASS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GLASS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CLOCHE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NAPKIN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TableSetBlockEntity(pos, state, this.size());
    }

    private static HashMap<Item, BooleanProperty> itemHashMap() {
        return (HashMap)Util.m_137469_(new HashMap(), map -> {
            map.put((Item)ObjectRegistry.WINE_GLASS.get(), WINE_GLASS);
            map.put((Item)ObjectRegistry.GLASS.get(), GLASS);
            map.put((Item)ObjectRegistry.CLOCHE.get(), CLOCHE);
            map.put((Item)ObjectRegistry.NAPKIN.get(), NAPKIN);
        });
    }

    private static Item getItemFromProperty(BooleanProperty property) {
        return TableSetBlock.itemHashMap().entrySet().stream().filter(entry -> ((BooleanProperty)entry.getValue()).equals((Object)property)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && (((Boolean)state.m_61143_((Property)GLASS_DRINK)).booleanValue() || ((Boolean)state.m_61143_((Property)WINE_GLASS_DRINK)).booleanValue())) {
            TableSetBlockEntity sbe;
            if (!world.m_5776_() && (sbe = (TableSetBlockEntity)world.m_7702_(pos)) != null) {
                if (((Boolean)state.m_61143_((Property)GLASS_DRINK)).booleanValue()) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
                } else if (((Boolean)state.m_61143_((Property)WINE_GLASS_DRINK)).booleanValue()) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(false)));
                }
                ItemStack effectStack = sbe.getEffectStack();
                if (!effectStack.m_41619_()) {
                    int duration = sbe.getEffectDuration();
                    List effects = PotionUtils.m_43547_((ItemStack)effectStack);
                    for (MobEffectInstance effect : effects) {
                        player.m_7292_(new MobEffectInstance(effect.m_19544_(), duration, effect.m_19564_()));
                    }
                    sbe.setEffectStack(ItemStack.f_41583_, 0);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!stack.m_41619_() && stack.m_41720_().m_204114_().m_203656_(ALL_EFFECTS)) {
            if (((Boolean)state.m_61143_((Property)GLASS)).booleanValue() && !((Boolean)state.m_61143_((Property)GLASS_DRINK)).booleanValue()) {
                TableSetBlockEntity sbe;
                if (!world.m_5776_() && (sbe = (TableSetBlockEntity)world.m_7702_(pos)) != null) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)GLASS_DRINK, (Comparable)Boolean.valueOf(true)));
                    if (stack.m_41782_()) {
                        int duration = PotionUtils.m_43547_((ItemStack)stack).stream().mapToInt(MobEffectInstance::m_19557_).max().orElse(6000);
                        sbe.setEffectStack(stack.m_41777_(), duration);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (((Boolean)state.m_61143_((Property)WINE_GLASS)).booleanValue() && !((Boolean)state.m_61143_((Property)WINE_GLASS_DRINK)).booleanValue()) {
                TableSetBlockEntity sbe;
                if (!world.m_5776_() && (sbe = (TableSetBlockEntity)world.m_7702_(pos)) != null) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)WINE_GLASS_DRINK, (Comparable)Boolean.valueOf(true)));
                    if (stack.m_41782_()) {
                        int duration = PotionUtils.m_43547_((ItemStack)stack).stream().mapToInt(MobEffectInstance::m_19557_).max().orElse(6000);
                        sbe.setEffectStack(stack.m_41777_(), duration);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        HashMap<Item, BooleanProperty> items = TableSetBlock.itemHashMap();
        if (player.m_6144_() && ((Boolean)state.m_61143_((Property)CLOCHE)).booleanValue()) {
            if (!world.m_5776_()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)CLOCHE, (Comparable)Boolean.valueOf(false)));
                ItemStack clocheItem = new ItemStack((ItemLike)TableSetBlock.getItemFromProperty(CLOCHE));
                if (!player.m_150109_().m_36054_(clocheItem)) {
                    player.m_36176_(clocheItem, false);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        Item item = stack.m_41720_();
        if (!items.containsKey(item)) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        BooleanProperty property = items.get(item);
        if (((Boolean)state.m_61143_((Property)property)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!world.m_5776_()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(true)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void remove(Level world, BlockPos blockPos, Player player, StorageBlockEntity shelfBlockEntity, int i) {
        TableSetBlockEntity tsbe = (TableSetBlockEntity)shelfBlockEntity;
        BlockState state = world.m_8055_(blockPos);
        if (!((Boolean)state.m_61143_((Property)CLOCHE)).booleanValue() && !world.m_5776_()) {
            ItemStack itemStack = tsbe.removeStack(i);
            SoundEvent soundEvent = SoundEvents.f_11912_;
            world.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemStack.m_41614_()) {
                FoodProperties foodComponent = itemStack.m_41720_().m_41473_();
                assert (foodComponent != null);
                player.m_36324_().m_38707_(Math.round((float)foodComponent.m_38744_() * 1.3f), foodComponent.m_38745_() * 1.3f);
                List list = foodComponent.m_38749_();
                for (Pair pair : list) {
                    if (pair.getFirst() == null || !(world.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
            }
            world.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        List list = super.m_49635_(blockState, builder);
        PlateType type = (PlateType)((Object)blockState.m_61143_(PLATE_TYPE));
        switch (type) {
            case PLATE: {
                list.add(new ItemStack((ItemLike)ObjectRegistry.PLATE.get()));
                break;
            }
            case BOWL: {
                list.add(new ItemStack((ItemLike)ObjectRegistry.BOWL.get()));
            }
        }
        for (BooleanProperty property : TableSetBlock.itemHashMap().values()) {
            Item item;
            if (!((Boolean)blockState.m_61143_((Property)property)).booleanValue() || (item = TableSetBlock.getItemFromProperty(property)) == null) continue;
            list.add(new ItemStack((ItemLike)item));
        }
        return list;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.TABLE_SET;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41614_();
    }

    @Override
    public int getSection(Float x, Float y) {
        return 0;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        return Block.m_49918_((VoxelShape)shape, (Direction)Direction.UP);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.farm_and_charm.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PLATE_TYPE});
        builder.m_61104_(new Property[]{WINE_GLASS, GLASS, CLOCHE, NAPKIN, GLASS_DRINK, WINE_GLASS_DRINK});
    }

    private VoxelShape makeBowlShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.125, (double)0.3125, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.125, (double)0.8125, (double)0.1875, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.6875, (double)0.8125, (double)0.1875, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.1875, (double)0.8125, (double)0.0625, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.1875, (double)0.3125, (double)1.0, (double)0.1875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.1875, (double)0.3125, (double)0.25, (double)0.1875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makePlateShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        PlateType type = (PlateType)((Object)state.m_61143_(PLATE_TYPE));
        if (type.equals((Object)PlateType.BOWL)) {
            return this.rotateShape(direction, this.makeBowlShape());
        }
        return this.rotateShape(direction, this.makePlateShape());
    }

    private VoxelShape rotateShape(Direction direction, VoxelShape shape) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        VoxelShape[] rotatedShapes = new VoxelShape[]{shape};
        for (int i = 0; i < (direction.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4; ++i) {
            rotatedShapes[0] = this.rotateShapeClockwise(rotatedShapes[0]);
        }
        return rotatedShapes[0];
    }

    private VoxelShape rotateShapeClockwise(VoxelShape shape) {
        VoxelShape[] result = new VoxelShape[]{Shapes.m_83040_()};
        shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinX = 1.0 - maxZ;
            double newMaxX = 1.0 - minZ;
            result[0] = Shapes.m_83110_((VoxelShape)result[0], (VoxelShape)Shapes.m_83048_((double)newMinX, (double)minY, (double)minX, (double)newMaxX, (double)maxY, (double)maxX));
        });
        return result[0];
    }

    public static enum PlateType implements StringRepresentable
    {
        PLATE("plate"),
        BOWL("bowl");

        private final String name;

        private PlateType(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

