/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.camping.block.BackpackBlock;
import net.satisfy.camping.block.BackpackType;
import net.satisfy.camping.block.EnderpackBlock;
import net.satisfy.camping.block.GrillBlock;
import net.satisfy.camping.block.SleepingBagBlock;
import net.satisfy.camping.block.TentMainBlock;
import net.satisfy.camping.block.TentMainHeadBlock;
import net.satisfy.camping.block.TentRightBlock;
import net.satisfy.camping.block.TentRightHeadBlock;
import net.satisfy.camping.item.BackpackItem;
import net.satisfy.camping.item.EnderpackItem;
import net.satisfy.camping.item.MultitoolItem;
import net.satisfy.camping.util.CampingIdentifier;
import net.satisfy.camping.util.CampingUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"camping", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"camping", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final Map<String, RegistrySupplier<Block>> SLEEPING_BAGS = new HashMap<String, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> GRILL = ObjectRegistry.registerWithItem("grill", () -> new GrillBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_).m_60953_(state -> (Boolean)state.m_61143_((Property)GrillBlock.LIT) != false ? 10 : 0), 1));
    public static final RegistrySupplier<Item> MULTITOOL = ObjectRegistry.registerItem("multitool", () -> new MultitoolItem(new Item.Properties().m_41497_(Rarity.COMMON).m_41487_(1).m_41503_(92).m_41486_()));
    public static final BlockBehaviour.Properties BACKPACK_BEHAVIOUR = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BIT).m_60978_(1.5f).m_60918_(SoundType.f_154653_).m_278183_().m_60955_().m_246721_().m_60966_();
    public static final RegistrySupplier<Block> SMALL_BACKPACK = ObjectRegistry.registerWithoutItem("small_backpack", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.SMALL_BACKPACK));
    public static final RegistrySupplier<Item> SMALL_BACKPACK_ITEM = ObjectRegistry.registerItem("small_backpack", () -> new BackpackItem((Block)SMALL_BACKPACK.get(), new CampingIdentifier("textures/model/small_backpack.png")));
    public static final RegistrySupplier<Block> LARGE_BACKPACK = ObjectRegistry.registerWithoutItem("large_backpack", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.LARGE_BACKPACK));
    public static final RegistrySupplier<Item> LARGE_BACKPACK_ITEM = ObjectRegistry.registerItem("large_backpack", () -> new BackpackItem((Block)LARGE_BACKPACK.get(), new CampingIdentifier("textures/model/large_backpack.png")));
    public static final RegistrySupplier<Block> WANDERER_BACKPACK = ObjectRegistry.registerWithoutItem("wanderer_backpack", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.WANDERER_BACKPACK));
    public static final RegistrySupplier<Item> WANDERER_BACKPACK_ITEM = ObjectRegistry.registerItem("wanderer_backpack", () -> new BackpackItem((Block)WANDERER_BACKPACK.get(), new CampingIdentifier("textures/model/wanderer_pack.png")));
    public static final RegistrySupplier<Block> WANDERER_BAG = ObjectRegistry.registerWithoutItem("wanderer_bag", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.WANDERER_BAG));
    public static final RegistrySupplier<Item> WANDERER_BAG_ITEM = ObjectRegistry.registerItem("wanderer_bag", () -> new BackpackItem((Block)WANDERER_BAG.get(), new CampingIdentifier("textures/model/wanderer_bag.png")));
    public static final RegistrySupplier<Block> GOODYBAG = ObjectRegistry.registerWithoutItem("goodybag", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.GOODYBAG));
    public static final RegistrySupplier<Item> GOODYBAG_ITEM = ObjectRegistry.registerItem("goodybag", () -> new BackpackItem((Block)GOODYBAG.get(), new CampingIdentifier("textures/model/goodybag.png")));
    public static final RegistrySupplier<Block> SHEEPBAG = ObjectRegistry.registerWithoutItem("sheepbag", () -> new BackpackBlock(BACKPACK_BEHAVIOUR, BackpackType.SHEEPBAG));
    public static final RegistrySupplier<Item> SHEEPBAG_ITEM = ObjectRegistry.registerItem("sheepbag", () -> new BackpackItem((Block)SHEEPBAG.get(), new CampingIdentifier("textures/model/sheepbag.png")));
    public static final RegistrySupplier<Block> ENDERPACK = ObjectRegistry.registerWithoutItem("enderpack", () -> new EnderpackBlock(BACKPACK_BEHAVIOUR, EnderpackBlock.BackpackType.ENDERPACK));
    public static final RegistrySupplier<Item> ENDERPACK_ITEM = ObjectRegistry.registerItem("enderpack", () -> new EnderpackItem((Block)ENDERPACK.get(), (ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, new CampingIdentifier("textures/model/enderpack.png"), new Item.Properties()));
    public static final RegistrySupplier<Block> ENDERBAG = ObjectRegistry.registerWithoutItem("enderbag", () -> new EnderpackBlock(BACKPACK_BEHAVIOUR, EnderpackBlock.BackpackType.ENDERBAG));
    public static final RegistrySupplier<Item> ENDERBAG_ITEM = ObjectRegistry.registerItem("enderbag", () -> new EnderpackItem((Block)ENDERBAG.get(), (ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, new CampingIdentifier("textures/model/enderbag.png"), new Item.Properties()));
    public static final String[] COLORS = new String[]{"white", "light_gray", "gray", "black", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink", "brown"};
    public static final Map<String, RegistrySupplier<Block>> TENT_MAIN = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> TENT_MAIN_HEAD = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> TENT_RIGHT = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> TENT_HEAD_RIGHT = new HashMap<String, RegistrySupplier<Block>>();

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return CampingUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, new CampingIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return CampingUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, new CampingIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return CampingUtil.registerItem(ITEMS, ITEM_REGISTRAR, new CampingIdentifier(path), itemSupplier);
    }

    static {
        for (String color : COLORS) {
            DyeColor dyeColor = DyeColor.valueOf((String)color.toUpperCase(Locale.ENGLISH));
            SLEEPING_BAGS.put(color, ObjectRegistry.registerWithItem("sleeping_bag_" + color, () -> new SleepingBagBlock(dyeColor, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.IGNORE).m_60966_().m_284268_(DyeColor.WHITE))));
            TENT_MAIN.put(color, ObjectRegistry.registerWithItem("tent_" + color, () -> new TentMainBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.IGNORE).m_60966_(), dyeColor)));
            TENT_MAIN_HEAD.put(color, ObjectRegistry.registerWithoutItem("tent_head_" + color, () -> new TentMainHeadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.IGNORE).m_60966_(), dyeColor)));
            TENT_RIGHT.put(color, ObjectRegistry.registerWithoutItem("tent_right_" + color, () -> new TentRightBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.IGNORE).m_60966_(), dyeColor)));
            TENT_HEAD_RIGHT.put(color, ObjectRegistry.registerWithoutItem("tent_head_right_" + color, () -> new TentRightHeadBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_).m_278166_(PushReaction.IGNORE).m_60966_(), dyeColor)));
        }
        BLOCKS.register();
        ITEMS.register();
    }
}

