/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.camping.block.entity.BackpackBlockEntity;
import net.satisfy.camping.block.entity.EnderpackBlockEntity;
import net.satisfy.camping.block.entity.GrillBlockEntity;
import net.satisfy.camping.registry.ObjectRegistry;
import net.satisfy.camping.util.CampingIdentifier;

public final class EntityTypeRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"camping", (ResourceKey)Registries.f_256939_);
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"camping", (ResourceKey)Registries.f_256922_).getRegistrar();
    public static final RegistrySupplier<BlockEntityType<GrillBlockEntity>> GRILL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("grill", () -> BlockEntityType.Builder.m_155273_(GrillBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GRILL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BackpackBlockEntity>> BACKPACK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("backpack", () -> BlockEntityType.Builder.m_155273_(BackpackBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SMALL_BACKPACK.get(), (Block)ObjectRegistry.LARGE_BACKPACK.get(), (Block)ObjectRegistry.WANDERER_BACKPACK.get(), (Block)ObjectRegistry.WANDERER_BAG.get(), (Block)ObjectRegistry.SHEEPBAG.get(), (Block)ObjectRegistry.GOODYBAG.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<EnderpackBlockEntity>> ENDERPACK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("enderpack", () -> BlockEntityType.Builder.m_155273_(EnderpackBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.ENDERPACK.get(), (Block)ObjectRegistry.ENDERBAG.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new CampingIdentifier(path), type);
    }

    static {
        ENTITY_TYPES.register();
    }
}

