/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.Item;
import net.satisfy.camping.client.model.BackpackModel;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.registry.ObjectRegistry;

public class BackpackRegistry {
    private static final Map<Item, BackpackModel> models = new HashMap<Item, BackpackModel>();

    public static Model getBodyModel(Item item, ModelPart baseBody) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        BackpackModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.SMALL_BACKPACK_ITEM.get()) {
                return new SmallBackpackModel(modelSet.m_171103_(SmallBackpackModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.LARGE_BACKPACK_ITEM.get()) {
                return new LargeBackpackModel(modelSet.m_171103_(LargeBackpackModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.WANDERER_BACKPACK_ITEM.get()) {
                return new WandererBackpackModel(modelSet.m_171103_(WandererBackpackModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.WANDERER_BAG_ITEM.get()) {
                return new WandererBagModel(modelSet.m_171103_(WandererBagModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.GOODYBAG_ITEM.get()) {
                return new GoodybagModel(modelSet.m_171103_(GoodybagModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.SHEEPBAG_ITEM.get()) {
                return new SheepbagModel(modelSet.m_171103_(SheepbagModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.ENDERPACK_ITEM.get()) {
                return new EnderpackModel(modelSet.m_171103_(EnderpackModel.LAYER_LOCATION));
            }
            if (key == ObjectRegistry.ENDERBAG_ITEM.get()) {
                return new EnderbagModel(modelSet.m_171103_(EnderbagModel.LAYER_LOCATION));
            }
            return null;
        });
        assert (model != null);
        model.copyBody(baseBody);
        return (Model)model;
    }
}

