/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.item;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.camping.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class EnderpackItem
extends BlockItem
implements Equipable {
    protected final ArmorMaterial material;
    protected final ArmorItem.Type type;
    private final ResourceLocation enderpackTexture;

    public EnderpackItem(Block block, ArmorMaterial material, ArmorItem.Type type, ResourceLocation enderpackTexture, Item.Properties properties) {
        super(block, properties.m_41487_(1));
        this.material = material;
        this.type = type;
        this.enderpackTexture = enderpackTexture;
    }

    public ResourceLocation getEnderpackTexture() {
        return this.enderpackTexture;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos relativePos = clickedPos.m_121945_(context.m_43719_());
        BlockState blockState = null;
        if (context.m_43722_().m_41720_() == ObjectRegistry.ENDERPACK_ITEM.get()) {
            blockState = ((Block)ObjectRegistry.ENDERPACK.get()).m_49966_();
        } else if (context.m_43722_().m_41720_() == ObjectRegistry.ENDERBAG_ITEM.get()) {
            blockState = ((Block)ObjectRegistry.ENDERBAG.get()).m_49966_();
        }
        if (blockState != null && player != null && level.m_46859_(relativePos) && level.m_46597_(relativePos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)player.m_6350_().m_122424_()))) {
            player.m_5496_(SoundEvents.f_11888_, 0.5f, 0.5f);
            level.m_142346_((Entity)player, GameEvent.f_157797_, relativePos);
            context.m_43722_().m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public EquipmentSlot m_40402_() {
        return this.type.m_266308_();
    }

    @NotNull
    public SoundEvent m_150681_() {
        return this.material.m_7344_();
    }
}

