/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.inventory;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackContainer
implements Container,
StackedContentsCompatible {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);
    @Nullable
    private List<ContainerListener> listeners;
    @Nullable
    private Player player;

    public BackpackContainer(NonNullList<ItemStack> itemStacks) {
        this.stacks = itemStacks;
    }

    public BackpackContainer(NonNullList<ItemStack> itemStacks, @Nullable Player player) {
        this(itemStacks);
        this.player = player;
    }

    public int m_6643_() {
        return 24;
    }

    public boolean m_7983_() {
        return this.stacks.stream().allMatch(Predicate.isEqual(ItemStack.f_41583_));
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.stacks.get(i);
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.stacks, (int)i, (int)j);
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.stacks, (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.stacks.set(i, (Object)itemStack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return !player.m_21224_();
    }

    public void m_6211_() {
        this.stacks.clear();
        this.m_6596_();
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemStack : this.stacks) {
            stackedContents.m_36491_(itemStack);
        }
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.player == null) {
            return;
        }
        NonNullList itemStacks = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);
        CompoundTag blockEntityTag = BlockItem.m_186336_((ItemStack)PlatformHelper.getEquippedBackpack(this.player));
        if (blockEntityTag == null) {
            CompoundTag compoundTag = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_));
            ItemStack itemStack1 = PlatformHelper.getEquippedBackpack(this.player);
            itemStack1.m_41700_("BlockEntityTag", (Tag)compoundTag);
            blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack1);
        }
        ContainerHelper.m_18980_((CompoundTag)blockEntityTag, (NonNullList)itemStacks);
        NonNullList<ItemStack> itemStacks1 = this.stacks;
        NonNullList itemStacks2 = itemStacks;
        if (itemStacks1.equals(itemStacks2)) {
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.stacks);
        PlatformHelper.getEquippedBackpack(this.player).m_41700_("BlockEntityTag", (Tag)compoundTag);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }
}

