/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.forge.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.forge.client.CampingClientForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CuriosBackpackRenderer
implements ICurioRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityModel<LivingEntity> model;
    private final ResourceLocation texture;

    public CuriosBackpackRenderer(BackpackType type) {
        switch (type) {
            case ENDERPACK: {
                this.model = new EnderpackModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.ENDERPACK_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/enderpack.png");
                break;
            }
            case ENDERBAG: {
                this.model = new EnderbagModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.ENDERBAG_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/enderbag.png");
                break;
            }
            case GOODYBAG: {
                this.model = new GoodybagModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.GOODYBAG_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/goodybag.png");
                break;
            }
            case LARGE_BACKPACK: {
                this.model = new LargeBackpackModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.LARGE_BACKPACK_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/large_backpack.png");
                break;
            }
            case SHEEPBAG: {
                this.model = new SheepbagModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.SHEEPBAG_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/sheepbag.png");
                break;
            }
            case WANDERER_BACKPACK: {
                this.model = new WandererBackpackModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.WANDERER_BACKPACK_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/wanderer_pack.png");
                break;
            }
            case WANDERER_BAG: {
                this.model = new WandererBagModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.WANDERER_BAG_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/wanderer_bag.png");
                break;
            }
            default: {
                this.model = new SmallBackpackModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(CampingClientForge.SMALL_BACKPACK_LAYER));
                this.texture = new ResourceLocation("camping", "textures/model/small_backpack.png");
            }
        }
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(@NotNull ItemStack stack, @NotNull SlotContext slotContext, @NotNull PoseStack matrixStack, @NotNull RenderLayerParent<T, M> renderLayerParent, @NotNull MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity == null) {
            LOGGER.warn("LivingEntity is null in CuriosBackpackRenderer");
            return;
        }
        this.model.m_6973_((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        matrixStack.m_85836_();
        if (this.model instanceof EnderpackModel) {
            matrixStack.m_252880_(0.0f, -1.0f, 0.025f);
        } else if (this.model instanceof EnderbagModel) {
            matrixStack.m_252880_(0.0f, -1.5f, 0.025f);
        } else if (this.model instanceof GoodybagModel) {
            matrixStack.m_252880_(0.38f, -1.45f, 0.36f);
        } else if (this.model instanceof LargeBackpackModel) {
            matrixStack.m_252880_(0.0f, -1.4f, 0.025f);
        } else if (this.model instanceof SheepbagModel) {
            matrixStack.m_252880_(0.175f, -1.5f, 0.43f);
        } else if (this.model instanceof WandererBackpackModel) {
            matrixStack.m_252880_(0.0f, -1.5f, 0.0f);
        } else if (this.model instanceof WandererBagModel) {
            matrixStack.m_252880_(0.3f, -1.5f, 0.4f);
        } else {
            matrixStack.m_252880_(-0.2f, -1.5f, 0.425f);
        }
        this.renderColoredCutoutModel(this.model, this.texture, matrixStack, renderTypeBuffer, light, livingEntity, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    private <T extends LivingEntity, M extends EntityModel<T>> void renderColoredCutoutModel(@NotNull M model, @NotNull ResourceLocation texture, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, @NotNull T entity, float red, float green, float blue) {
        model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    public static enum BackpackType {
        SMALL_BACKPACK,
        ENDERPACK,
        ENDERBAG,
        GOODYBAG,
        LARGE_BACKPACK,
        SHEEPBAG,
        WANDERER_BACKPACK,
        WANDERER_BAG;

    }
}

