/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.forge.client;

import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.satisfy.camping.client.CampingClient;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.forge.client.renderer.player.layers.EnderbagLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.EnderpackLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.GoodybagLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.LargeBackpackLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.SheepbagLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.SmallBackpackLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.WandererBackpackLayer;
import net.satisfy.camping.forge.client.renderer.player.layers.WandererBagLayer;

@Mod.EventBusSubscriber(modid="camping", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CampingClientForge {
    public static final ModelLayerLocation SMALL_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "small_backpack"), "main");
    public static final ModelLayerLocation LARGE_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "large_backpack"), "main");
    public static final ModelLayerLocation WANDERER_BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "wanderer_backpack"), "main");
    public static final ModelLayerLocation WANDERER_BAG_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "wanderer_bag"), "main");
    public static final ModelLayerLocation SHEEPBAG_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "sheepbag"), "main");
    public static final ModelLayerLocation GOODYBAG_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "goodybag"), "main");
    public static final ModelLayerLocation ENDERPACK_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "enderpack"), "main");
    public static final ModelLayerLocation ENDERBAG_LAYER = new ModelLayerLocation(new ResourceLocation("camping", "enderbag"), "main");

    @SubscribeEvent
    public static void beforeClientSetup(RegisterEvent event) {
        CampingClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        CampingClient.onInitializeClient();
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SMALL_BACKPACK_LAYER, SmallBackpackModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_BACKPACK_LAYER, LargeBackpackModel::createBodyLayer);
        event.registerLayerDefinition(WANDERER_BACKPACK_LAYER, WandererBackpackModel::createBodyLayer);
        event.registerLayerDefinition(WANDERER_BAG_LAYER, WandererBagModel::createBodyLayer);
        event.registerLayerDefinition(SHEEPBAG_LAYER, SheepbagModel::createBodyLayer);
        event.registerLayerDefinition(GOODYBAG_LAYER, GoodybagModel::createBodyLayer);
        event.registerLayerDefinition(ENDERPACK_LAYER, EnderpackModel::createBodyLayer);
        event.registerLayerDefinition(ENDERBAG_LAYER, EnderbagModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void constructLayers(EntityRenderersEvent.AddLayers event) {
        CampingClientForge.addLayerToPlayerSkin(event, "default", SmallBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", SmallBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", LargeBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", LargeBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", WandererBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", WandererBackpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", WandererBagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", WandererBagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", SheepbagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", SheepbagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", GoodybagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", GoodybagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", EnderpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", EnderpackLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "default", EnderbagLayer::new);
        CampingClientForge.addLayerToPlayerSkin(event, "slim", EnderbagLayer::new);
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

