/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.forge;

import dev.architectury.platform.forge.EventBuses;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.satisfy.camping.Camping;
import net.satisfy.camping.block.SleepingBagBlock;
import net.satisfy.camping.forge.integration.CuriosBackpack;
import net.satisfy.camping.forge.integration.CuriosBackpackRenderer;
import net.satisfy.camping.registry.ObjectRegistry;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod(value="camping")
public class CampingForge {
    public CampingForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus((String)"camping", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        Camping.init();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::clientSetup);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void setup(FMLCommonSetupEvent evt) {
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.SMALL_BACKPACK_ITEM.get()), (ICurioItem)new CuriosBackpack());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.SMALL_BACKPACK_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.SMALL_BACKPACK));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.ENDERPACK_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.ENDERPACK));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.ENDERBAG_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.ENDERBAG));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.GOODYBAG_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.GOODYBAG));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.LARGE_BACKPACK_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.LARGE_BACKPACK));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.SHEEPBAG_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.SHEEPBAG));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.WANDERER_BACKPACK_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.WANDERER_BACKPACK));
        CuriosRendererRegistry.register((Item)((Item)ObjectRegistry.WANDERER_BAG_ITEM.get()), () -> new CuriosBackpackRenderer(CuriosBackpackRenderer.BackpackType.WANDERER_BAG));
    }

    @Mod.EventBusSubscriber(modid="camping", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventsHandler {
        @SubscribeEvent
        public static void playerSetSpawn(PlayerSetSpawnEvent event) {
            Level level = event.getEntity().m_9236_();
            if (event.getNewSpawn() != null) {
                Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
                if (!level.f_46443_ && block instanceof SleepingBagBlock && !event.isForced()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

