/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.camping.client.model.EnderbagModel;
import net.satisfy.camping.client.model.EnderpackModel;
import net.satisfy.camping.client.model.GoodybagModel;
import net.satisfy.camping.client.model.LargeBackpackModel;
import net.satisfy.camping.client.model.SheepbagModel;
import net.satisfy.camping.client.model.SmallBackpackModel;
import net.satisfy.camping.client.model.WandererBackpackModel;
import net.satisfy.camping.client.model.WandererBagModel;
import net.satisfy.camping.client.renderer.GrillRenderer;
import net.satisfy.camping.client.screen.BackpackScreen;
import net.satisfy.camping.registry.EntityTypeRegistry;
import net.satisfy.camping.registry.KeyHandlerRegistry;
import net.satisfy.camping.registry.ObjectRegistry;
import net.satisfy.camping.registry.ScreenhandlerTypeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class CampingClient {
    public static void onInitializeClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.GRILL.get()});
        for (RegistrySupplier<Block> block : Stream.concat(ObjectRegistry.TENT_MAIN.values().stream(), Stream.concat(ObjectRegistry.TENT_MAIN_HEAD.values().stream(), Stream.concat(ObjectRegistry.TENT_RIGHT.values().stream(), ObjectRegistry.TENT_HEAD_RIGHT.values().stream()))).toList()) {
            RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)block.get()});
        }
        KeyHandlerRegistry.init();
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenhandlerTypeRegistry.BACKPACK_SCREENHANDLER.get()), BackpackScreen::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.GRILL_BLOCK_ENTITY.get()), GrillRenderer::new);
    }

    public static void preInitClient() {
        CampingClient.registerEntityModelLayer();
        CampingClient.registerEntityRenderers();
    }

    public static void registerEntityRenderers() {
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)SmallBackpackModel.LAYER_LOCATION, SmallBackpackModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LargeBackpackModel.LAYER_LOCATION, LargeBackpackModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WandererBackpackModel.LAYER_LOCATION, WandererBackpackModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)WandererBagModel.LAYER_LOCATION, WandererBagModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)GoodybagModel.LAYER_LOCATION, GoodybagModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SheepbagModel.LAYER_LOCATION, SheepbagModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)EnderpackModel.LAYER_LOCATION, EnderpackModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)EnderbagModel.LAYER_LOCATION, EnderbagModel::createBodyLayer);
    }
}

