/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.camping.client.screen.BackpackScreenHandler;
import net.satisfy.camping.inventory.BackpackContainer;
import net.satisfy.camping.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BackpackBlockEntity
extends BaseContainerBlockEntity {
    public static final int CONTAINER_SIZE = 24;
    public static final String ITEMS_TAG = "Items";
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);

    public BackpackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.BACKPACK_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.getItems().get(i);
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.getItems(), (int)i, (int)j);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.getItems(), (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.getItems().set(i, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.camping.backpack");
    }

    public void m_142466_(CompoundTag compoundTag) {
        this.loadFromTag(compoundTag);
        super.m_142466_(compoundTag);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        ContainerHelper.m_18976_((CompoundTag)compoundTag, this.itemStacks, (boolean)false);
        super.m_183515_(compoundTag);
    }

    public void loadFromTag(CompoundTag compoundTag) {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (compoundTag.m_128425_(ITEMS_TAG, 9)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.itemStacks);
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new BackpackScreenHandler(i, inventory, new BackpackContainer(this.itemStacks));
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public void m_6596_() {
        super.m_6596_();
    }
}

