/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.camping.platform.PlatformHelper;
import net.satisfy.camping.util.CampingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.f_61428_;
    protected static final VoxelShape SLEEPING_BAG_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);

    public SleepingBagBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties.m_280606_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE)).m_61124_((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.m_61143_(PART) == BedPart.HEAD ? CampingUtil.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)f_54117_), SLEEPING_BAG_SHAPE) : SLEEPING_BAG_SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_(PART) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(pos).ifLeft(failureReason -> {
            if (failureReason.m_36423_() != null) {
                player.m_5661_(failureReason.m_36423_(), true);
            }
        }).ifRight(success -> PlatformHelper.addRegenEffect(player, new MobEffectInstance(MobEffects.f_19605_, 200, 1)));
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float factor) {
        super.m_142072_(level, state, pos, entity, factor * 0.5f);
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        if (deltaMovement.f_82480_ < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 0.75 : 0.8;
            entity.m_20334_(deltaMovement.f_82479_, -deltaMovement.f_82480_ * 0.3300000262260437 * bounceFactor, deltaMovement.f_82481_);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        if (direction == SleepingBagBlock.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return newState.m_60713_((Block)this) && newState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)newState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, accessor, pos, newPos);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, CAN_DROP});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemstack) {
        super.m_6402_(level, pos, state, livingEntity, itemstack);
        if (!level.f_46443_) {
            BlockPos headPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(headPos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos seedPos = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)seedPos.m_123341_(), (int)pos.m_123342_(), (int)seedPos.m_123343_());
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (!((Boolean)state.m_61143_((Property)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.m_49635_(state, builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }
}

