/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.client.gui.WallDecorationEditGui;
import net.satisfy.brewery.client.model.BeerElementalModel;
import net.satisfy.brewery.client.model.BrewfestBootsModel;
import net.satisfy.brewery.client.model.BrewfestChestplateModel;
import net.satisfy.brewery.client.model.BrewfestHatModel;
import net.satisfy.brewery.client.model.BrewfestLeggingsModel;
import net.satisfy.brewery.client.model.RopeKnotEntityModel;
import net.satisfy.brewery.client.renderer.block.BeerMugRenderer;
import net.satisfy.brewery.client.renderer.block.BeverageRenderer;
import net.satisfy.brewery.client.renderer.block.BrewingstationRenderer;
import net.satisfy.brewery.client.renderer.block.CompletionistBannerRenderer;
import net.satisfy.brewery.client.renderer.block.StorageBlockEntityRenderer;
import net.satisfy.brewery.client.renderer.block.WallDecorationBlockRenderer;
import net.satisfy.brewery.client.renderer.entity.BeerElementalAttackRenderer;
import net.satisfy.brewery.client.renderer.entity.BeerElementalRenderer;
import net.satisfy.brewery.client.renderer.entity.HangingRopeRenderer;
import net.satisfy.brewery.client.renderer.entity.RopeCollisionEntityRenderer;
import net.satisfy.brewery.client.renderer.entity.RopeKnotRenderer;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.brewery.core.event.PlayerJoinEvent;
import net.satisfy.brewery.core.item.ItemPredicate;
import net.satisfy.brewery.core.network.BreweryNetworking;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ModelRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.StorageTypeRegistry;
import net.satisfy.brewery.core.util.rope.RopeHelper;

@OnlyIn(value=Dist.CLIENT)
public class BreweryClient {
    public static void onInitializeClient() {
        BreweryNetworking.registerS2CPackets();
        ItemPredicate.register();
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.WILD_HOPS.get(), (Block)ObjectRegistry.BEER_MUG.get(), (Block)ObjectRegistry.BEER_WHEAT.get(), (Block)ObjectRegistry.BEER_HOPS.get(), (Block)ObjectRegistry.BEER_BARLEY.get(), (Block)ObjectRegistry.BEER_HALEY.get(), (Block)ObjectRegistry.BEER_OAT.get(), (Block)ObjectRegistry.BEER_NETTLE.get(), (Block)ObjectRegistry.HOPS_CROP_BODY.get(), (Block)ObjectRegistry.HOPS_CROP.get(), (Block)ObjectRegistry.WHISKEY_MAGGOALLAN.get(), (Block)ObjectRegistry.WHISKEY_CARRASCONLABEL.get(), (Block)ObjectRegistry.WHISKEY_LILITUSINGLEMALT.get(), (Block)ObjectRegistry.WHISKEY_JOJANNIK.get(), (Block)ObjectRegistry.WHISKEY_MAGGOALLAN.get(), (Block)ObjectRegistry.WHISKEY_CRISTELWALKER.get(), (Block)ObjectRegistry.WHISKEY_AK.get(), (Block)ObjectRegistry.WHISKEY_HIGHLAND_HEARTH.get(), (Block)ObjectRegistry.WHISKEY_JAMESONS_MALT.get(), (Block)ObjectRegistry.WHISKEY_SMOKEY_REVERIE.get(), (Block)ObjectRegistry.BREWERY_BANNER.get(), (Block)ObjectRegistry.BREWERY_WALL_BANNER.get()});
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_BREWINGSTATION, ObjectRegistry.COPPER_BREWINGSTATION, ObjectRegistry.NETHERITE_BREWINGSTATION});
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.BREWERY_BANNER.get()), CompletionistBannerRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get()), context -> new StorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.BEER_MUG_BLOCK_ENTITY.get()), BeerMugRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.BREWINGSTATION_BLOCK_ENTITY.get()), BrewingstationRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.WALL_DECORATION.get()), context -> new WallDecorationBlockRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.BEVERAGE, new BeverageRenderer());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register((Object)new PlayerJoinEvent());
        ClientTickEvent.CLIENT_LEVEL_PRE.register(clientLevel -> RopeHelper.tick());
    }

    public static void openStreetSignScreen(WallDecorationBlockEntity entity) {
        Minecraft.m_91087_().m_91152_((Screen)new WallDecorationEditGui(entity));
    }

    public static void preInitClient() {
        BreweryClient.registerEntityRenderers();
        BreweryClient.registerEntityModelLayers();
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.ROPE_KNOT, RopeKnotRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.HANGING_ROPE, HangingRopeRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.ROPE_COLLISION, RopeCollisionEntityRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.BEER_ELEMENTAL, BeerElementalRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.BEER_ELEMENTAL_ATTACK, BeerElementalAttackRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.DARK_BREW, ThrownItemRenderer::new);
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)BrewfestHatModel.LAYER_LOCATION, BrewfestHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BrewfestChestplateModel.LAYER_LOCATION, BrewfestChestplateModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BrewfestLeggingsModel.LAYER_LOCATION, BrewfestLeggingsModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BrewfestBootsModel.LAYER_LOCATION, BrewfestBootsModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BeerElementalModel.BEER_ELEMENTAL_MODEL_LAYER, BeerElementalModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)ModelRegistry.ROPE_KNOT, RopeKnotEntityModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CompletionistBannerRenderer.LAYER_LOCATION, CompletionistBannerRenderer::createBodyLayer);
    }

    public static LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

