/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.lectern_hub.mixin;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CustomLecternBlock.class})
public class CustomLecternBlockMixin {
    @Unique
    @Nullable
    private static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    @Unique
    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @Unique
    @Nullable
    private static ServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return registry.get(CustomLecternBlockMixin.getSessionID(stack), CustomLecternBlockMixin.getInstanceID(stack));
    }

    @Unique
    @Nullable
    private static ServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return CustomLecternBlockMixin.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
    }

    @Inject(method={"replaceLectern"}, at={@At(value="HEAD")})
    private static void replaceLectern(Level level, BlockPos pos, BlockState blockState, ItemStack item, CallbackInfo ci) {
        if (level.f_46443_) {
            return;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)item2;
            ServerComputer serverComp = CustomLecternBlockMixin.getServerComputer(level.m_7654_(), item);
            BlockEntity periphBlk = level.getExistingBlockEntity(pos.m_7918_(0, -1, 0));
            if (periphBlk == null || serverComp == null) {
                return;
            }
            if (periphBlk instanceof WiredModemFullBlockEntity) {
                WiredModemFullBlockEntity modemFullBlock = (WiredModemFullBlockEntity)periphBlk;
                periphBlk.getCapability(Capabilities.CAPABILITY_PERIPHERAL, Direction.DOWN).ifPresent(iPeripheral -> serverComp.setPeripheral(ComputerSide.BOTTOM, iPeripheral));
            }
        }
    }

    @Inject(method={"dropItem"}, at={@At(value="HEAD")})
    private static void dropItem(Level level, BlockPos pos, BlockState state, ItemStack stack, CallbackInfo ci) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof PocketComputerItem) {
            ServerComputer serverComp = CustomLecternBlockMixin.getServerComputer(level.m_7654_(), stack);
            serverComp.setPeripheral(ComputerSide.BOTTOM, null);
        }
    }
}

