/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.lectern_hub.block.lectern;

import com.awesoft.lectern_hub.block.lectern.LecternPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="lectern_hub")
public class LecternPeripheralProvider {
    private static final ResourceLocation ID = new ResourceLocation("lectern_hub", "pocket_computer");

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)object;
            final LecternPeripheral peripheral = new LecternPeripheral(lectern);
            event.addCapability(ID, new ICapabilityProvider(){
                private final LazyOptional<IPeripheral> lazy = LazyOptional.of(() -> peripheral);

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
                        return this.lazy.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

