/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.lectern_hub.block.lectern;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LecternPeripheral
implements IPeripheral {
    private int invalidSides = 0;
    private final CustomLecternBlockEntity blkEntity;

    public LecternPeripheral(CustomLecternBlockEntity blkEntity) {
        this.blkEntity = blkEntity;
    }

    public String getType() {
        return "cc_lectern";
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }

    @javax.annotation.Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return registry.get(LecternPeripheral.getSessionID(stack), LecternPeripheral.getInstanceID(stack));
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return LecternPeripheral.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
    }

    public void attach(@Nonnull IComputerAccess computer) {
        super.attach(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        super.detach(computer);
    }

    public ItemStack getPocket() {
        if (this.blkEntity.m_58904_() == null || this.blkEntity.m_58904_().f_46443_) {
            return null;
        }
        ItemStack item = this.blkEntity.getItem();
        Item item2 = item.m_41720_();
        if (!(item2 instanceof PocketComputerItem)) {
            return null;
        }
        PocketComputerItem pocketItem = (PocketComputerItem)item2;
        return item;
    }

    public ServerComputer getPocketComputer(ItemStack item) {
        ServerComputer serverComp = LecternPeripheral.getServerComputer(this.blkEntity.m_58904_().m_7654_(), item);
        return serverComp;
    }

    public boolean isValid() {
        return this.blkEntity.getItem().m_41720_() instanceof PocketComputerItem;
    }

    @LuaFunction
    public final void turnOn() {
        if (!this.isValid()) {
            return;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        if (computer != null) {
            computer.turnOn();
        }
    }

    @LuaFunction
    public final void shutdown() {
        if (!this.isValid()) {
            return;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        if (computer != null) {
            computer.shutdown();
        }
    }

    @LuaFunction
    public final void reboot() {
        if (!this.isValid()) {
            return;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        if (computer != null) {
            computer.reboot();
        }
    }

    @LuaFunction
    public final int getID() {
        if (!this.isValid()) {
            return -1;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        return computer.getID();
    }

    @LuaFunction
    public final boolean isOn() {
        if (!this.isValid()) {
            return false;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        return computer != null && computer.isOn();
    }

    @javax.annotation.Nullable
    @LuaFunction
    public final String getLabel() {
        if (!this.isValid()) {
            return null;
        }
        ServerComputer computer = this.getPocketComputer(this.getPocket());
        return computer.getLabel();
    }

    @LuaFunction
    public final boolean isPocket() {
        return this.isValid();
    }
}

