/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    @Nullable
    public static Document loadXml(InputStream inputstream) {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputstream);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getAsInt(Element element, String name, int defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Integer.parseInt(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getAsLong(Element element, String name, long defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Long.parseLong(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getAsBoolean(Element element, String name, boolean defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Boolean.parseBoolean(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getAsString(Element element, String name, String defaultValue) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return defaultValue;
    }

    public static float getAsFloat(Element element, String name, float defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Float.parseFloat(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getAsColor(Element element, String name, int defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                int value = Long.decode(element.getAttribute(name)).intValue();
                if (value != 0 && (value & 0xFF000000) == 0) {
                    value |= 0xFF000000;
                }
                return value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static BlockPos getAsBlockPos(Element element, String name, BlockPos defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0 0");
            try {
                String[] s = pos.split(" ");
                return new BlockPos(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> T getAsEnum(Element element, String name, Class<T> enumClass, T defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                Enum[] values;
                String data = element.getAttribute(name);
                for (Enum value : values = (Enum[])enumClass.getEnumConstants()) {
                    if (!value.name().equals(data)) continue;
                    return (T)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static CompoundTag getCompoundTag(Element element) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String text = node.getTextContent().replaceAll("\\h*\\R+\\h*", " ");
            if (!text.isEmpty() && text.charAt(0) == ' ') {
                text = text.substring(1);
            }
            builder.append(text);
        }
        if (!builder.isEmpty()) {
            try {
                return TagParser.m_129359_((String)builder.toString());
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return new CompoundTag();
    }

    public static ItemStack getItemStack(Element element) {
        SizedIngredient ingredient = XmlUtils.getIngredient(element);
        if (ingredient.ingredient.m_43908_().length > 0) {
            ItemStack stack = ingredient.ingredient.m_43908_()[0];
            stack.m_41764_(ingredient.count);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static Vec3 getAsVec3(Element element, String name, Vec3 defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0 0");
            try {
                String[] s = pos.split(" ");
                return new Vec3((double)Float.parseFloat(s[0]), (double)Float.parseFloat(s[1]), (double)Float.parseFloat(s[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Vec2 getAsVec2(Element element, String name, Vec2 defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0");
            try {
                String[] s = pos.split(" ");
                return new Vec2(Float.parseFloat(s[0]), Float.parseFloat(s[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static EntityInfo getEntityInfo(Element element) {
        int id = XmlUtils.getAsInt(element, "id", LDLib.random.nextInt());
        EntityType entityType = null;
        if (element.hasAttribute("type")) {
            entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(element.getAttribute("type")));
        }
        CompoundTag tag = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element subElement;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(subElement = (Element)node).getNodeName().equals("nbt")) continue;
            tag = XmlUtils.getCompoundTag(subElement);
            break;
        }
        return new EntityInfo(id, entityType, tag);
    }

    public static SizedIngredient getIngredient(Element element) {
        int count = XmlUtils.getAsInt(element, "count", 1);
        SizedIngredient ingredient = new SizedIngredient(Ingredient.f_43901_, 0);
        if (element.hasAttribute("item")) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(element.getAttribute("item")));
            if (item != Items.f_41852_) {
                ItemStack itemStack = new ItemStack((ItemLike)item, count);
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element subElement;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !(subElement = (Element)node).getNodeName().equals("nbt")) continue;
                    itemStack.m_41751_(XmlUtils.getCompoundTag(subElement));
                    break;
                }
                ingredient = new SizedIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), count);
            }
        } else if (Platform.isForge() && element.hasAttribute("forge-tag")) {
            ingredient = new SizedIngredient(Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(element.getAttribute("forge-tag")))), count);
        } else if (!Platform.isForge() && element.hasAttribute("fabric-tag")) {
            ingredient = new SizedIngredient(Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(element.getAttribute("fabric-tag")))), count);
        } else if (element.hasAttribute("tag")) {
            ingredient = new SizedIngredient(Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(element.getAttribute("tag")))), count);
        }
        return ingredient;
    }

    public static FluidStack getFluidStack(Element element) {
        Fluid fluid;
        long amount = XmlUtils.getAsLong(element, "amount", 1L) * FluidHelper.getBucket() / 1000L;
        FluidStack fluidStack = FluidStack.empty();
        if (element.hasAttribute("fluid") && (fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(element.getAttribute("fluid")))) != Fluids.f_76191_) {
            fluidStack = FluidStack.create(fluid, amount);
            NodeList nodeList = element.getChildNodes();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String text = node.getTextContent().replaceAll("\\h*\\R+\\h*", " ");
                if (!text.isEmpty() && text.charAt(0) == ' ') {
                    text = text.substring(1);
                }
                builder.append(text);
            }
            if (!builder.isEmpty()) {
                try {
                    fluidStack.setTag(TagParser.m_129359_((String)builder.toString()));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        return fluidStack;
    }

    public static BlockInfo getBlockInfo(Element element) {
        Block block;
        BlockInfo blockInfo = BlockInfo.EMPTY;
        if (element.hasAttribute("block") && (block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(element.getAttribute("block")))) != Blocks.f_50016_) {
            BlockState blockState = block.m_49966_();
            NodeList nodeList = element.getChildNodes();
            CompoundTag tag = new CompoundTag();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element subElement = (Element)node;
                if (subElement.getNodeName().equals("properties")) {
                    blockState = XmlUtils.setBlockState(blockState, subElement);
                    continue;
                }
                if (!subElement.getNodeName().equals("nbt")) continue;
                tag = XmlUtils.getCompoundTag(subElement);
            }
            blockInfo = BlockInfo.fromBlockState(blockState);
            if (!tag.m_128456_()) {
                blockInfo.setTag(tag);
            }
        }
        return blockInfo;
    }

    public static BlockState setBlockState(BlockState blockState, Element element) {
        Property property;
        StateDefinition stateDefinition = blockState.m_60734_().m_49965_();
        String name = XmlUtils.getAsString(element, "name", "");
        String value = XmlUtils.getAsString(element, "value", "");
        if (!name.isEmpty() && (property = stateDefinition.m_61081_(name)) != null) {
            blockState = XmlUtils.setValueHelper(blockState, property, value);
        }
        return blockState;
    }

    private static BlockState setValueHelper(BlockState stateHolder, Property property, String value) {
        Optional optional = property.m_6215_(value);
        if (optional.isPresent()) {
            return (BlockState)stateHolder.m_61124_(property, (Comparable)optional.get());
        }
        return stateHolder;
    }

    public static String getContent(Element element, boolean pretty) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder builder = new StringBuilder();
        boolean lastNodeIsText = false;
        block8: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String text = node.getTextContent();
                if (pretty) {
                    text = text.replaceAll("\\h*\\R+\\h*", " ");
                }
                if (!lastNodeIsText && !text.isEmpty() && text.charAt(0) == ' ') {
                    text = text.substring(1);
                }
                builder.append(text);
                lastNodeIsText = false;
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element nodeElement = (Element)node;
            String nodeName = nodeElement.getNodeName();
            lastNodeIsText = false;
            switch (nodeName) {
                case "lang": {
                    String key = XmlUtils.getAsString(nodeElement, "key", "");
                    builder.append(LocalizationUtils.format(key, new Object[0]));
                    lastNodeIsText = true;
                    continue block8;
                }
                case "br": {
                    builder.append('\n');
                }
            }
        }
        return builder.toString();
    }

    public static List<MutableComponent> getComponents(Element element, Style style) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<MutableComponent> results = new ArrayList<MutableComponent>();
        MutableComponent component = null;
        block10: for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String text = node.getTextContent();
                text = text.replaceAll("\\h*\\R+\\h*", " ");
                if (component == null) {
                    component = Component.m_237113_((String)text).m_130948_(style);
                    continue;
                }
                component = component.m_7220_((Component)Component.m_237113_((String)text).m_130948_(style));
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element nodeElement = (Element)node;
            switch (nodeName = nodeElement.getNodeName()) {
                case "lang": {
                    String key = XmlUtils.getAsString(nodeElement, "key", "");
                    if (component == null) {
                        component = Component.m_237115_((String)key).m_130948_(style);
                        continue block10;
                    }
                    component = component.m_7220_((Component)Component.m_237115_((String)key).m_130948_(style));
                    continue block10;
                }
                case "br": {
                    results.add(Objects.requireNonNullElseGet(component, Component::m_237119_));
                    component = Component.m_237119_();
                    continue block10;
                }
                case "style": {
                    Style newStyle = style.m_131148_(style.m_131135_());
                    if (nodeElement.hasAttribute("color")) {
                        newStyle = newStyle.m_178520_(XmlUtils.getAsColor(nodeElement, "color", -1));
                    }
                    if (nodeElement.hasAttribute("bold")) {
                        newStyle = newStyle.m_131136_(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "bold", true)));
                    }
                    if (nodeElement.hasAttribute("font")) {
                        newStyle = newStyle.m_131150_(new ResourceLocation(nodeElement.getAttribute("font")));
                    }
                    if (nodeElement.hasAttribute("italic")) {
                        newStyle = newStyle.m_131155_(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "italic", true)));
                    }
                    if (nodeElement.hasAttribute("underlined")) {
                        newStyle = newStyle.m_131162_(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "underlined", true)));
                    }
                    if (nodeElement.hasAttribute("strikethrough")) {
                        newStyle = newStyle.m_178522_(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "strikethrough", true)));
                    }
                    if (nodeElement.hasAttribute("obfuscated")) {
                        newStyle = newStyle.m_178524_(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "obfuscated", true)));
                    }
                    if (nodeElement.hasAttribute("hover-info")) {
                        newStyle = newStyle.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)nodeElement.getAttribute("hover-info"))));
                    }
                    if (nodeElement.hasAttribute("link")) {
                        newStyle = newStyle.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "@!" + nodeElement.getAttribute("link")));
                    }
                    if (nodeElement.hasAttribute("url-link")) {
                        newStyle = newStyle.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "@#" + nodeElement.getAttribute("url-link")));
                    }
                    List<MutableComponent> components = XmlUtils.getComponents(nodeElement, newStyle);
                    for (int j = 0; j < components.size(); ++j) {
                        if (j == 0) {
                            if (component != null) {
                                component.m_7220_((Component)components.get(j));
                                continue;
                            }
                            component = components.get(j);
                            continue;
                        }
                        results.add(component);
                        component = components.get(j);
                    }
                    continue block10;
                }
            }
        }
        if (component != null) {
            results.add(component);
        }
        return results;
    }

    public record SizedIngredient(Ingredient ingredient, int count) {
    }
}

