/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.utils.ISearch;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class SearchEngine<T> {
    private final ISearch<T> search;
    private final Consumer<T> result;
    private Thread thread;

    public SearchEngine(@Nonnull ISearch<T> search, @Nonnull Consumer<T> result) {
        this.search = search;
        this.result = result;
    }

    public void searchWord(String word) {
        this.dispose();
        this.thread = new Thread(() -> this.search.search(word, value -> {
            Thread currentThread = Thread.currentThread();
            if (currentThread.isInterrupted() || this.thread != currentThread) {
                throw new RuntimeException("searching thread has been disposed");
            }
            this.result.accept(value);
        }));
        this.thread.start();
    }

    public boolean isSearching() {
        return this.thread != null && this.thread.isAlive();
    }

    public void dispose() {
        if (this.isSearching()) {
            this.thread.interrupt();
        }
        this.thread = null;
    }
}

