/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.field;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedHolder;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.rpc.RPCSender;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;

public class RPCMethodMeta {
    private final String name;
    private final ManagedAccessor[] argsAccessor;
    private final Class<?>[] argsType;
    private final Method method;
    private final boolean isFirstArgSender;

    public RPCMethodMeta(Method method) {
        this.method = method;
        method.setAccessible(true);
        this.name = method.getName();
        Parameter[] args = method.getParameters();
        if (args.length == 0) {
            this.argsAccessor = new ManagedAccessor[0];
            this.argsType = new Class[0];
            this.isFirstArgSender = false;
        } else {
            Parameter firstArg = args[0];
            if (RPCSender.class.isAssignableFrom(firstArg.getType())) {
                this.argsAccessor = new ManagedAccessor[args.length - 1];
                this.argsType = new Class[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    Parameter arg = args[i];
                    this.argsAccessor[i - 1] = RPCMethodMeta.getAccessor(arg.getType());
                    this.argsType[i - 1] = arg.getType();
                }
                this.isFirstArgSender = true;
            } else {
                this.argsAccessor = new ManagedAccessor[args.length];
                this.argsType = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Parameter arg = args[i];
                    this.argsAccessor[i] = RPCMethodMeta.getAccessor(arg.getType());
                    this.argsType[i] = arg.getType();
                }
                this.isFirstArgSender = false;
            }
        }
    }

    public void invoke(Object instance, RPCSender sender, ITypedPayload<?>[] payloads) {
        Object[] args;
        if (this.argsAccessor.length != payloads.length) {
            throw new IllegalArgumentException("Invalid number of arguments, expected " + this.argsAccessor.length + " but got " + payloads.length);
        }
        if (this.isFirstArgSender) {
            args = new Object[this.argsAccessor.length + 1];
            args[0] = sender;
            for (i = 0; i < this.argsAccessor.length; ++i) {
                args[i + 1] = RPCMethodMeta.deserialize(payloads[i], this.argsType[i], this.argsAccessor[i]);
            }
        } else {
            args = new Object[this.argsAccessor.length];
            for (i = 0; i < this.argsAccessor.length; ++i) {
                args[i] = RPCMethodMeta.deserialize(payloads[i], this.argsType[i], this.argsAccessor[i]);
            }
        }
        try {
            this.method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ITypedPayload<?>[] serializeArgs(Object[] args) {
        if (this.argsAccessor.length != args.length) {
            throw new IllegalArgumentException("Invalid number of arguments, expected " + this.argsAccessor.length + " but got " + args.length);
        }
        ITypedPayload[] payloads = new ITypedPayload[this.argsAccessor.length];
        for (int i = 0; i < this.argsAccessor.length; ++i) {
            payloads[i] = RPCMethodMeta.serialize(args[i], this.argsAccessor[i]);
        }
        return payloads;
    }

    private static ManagedAccessor getAccessor(Type type) {
        IAccessor accessor = TypedPayloadRegistries.findByType(type);
        if (accessor == null) {
            throw new IllegalArgumentException("Cannot find accessor for type " + String.valueOf(type));
        }
        if (accessor instanceof ManagedAccessor) {
            return (ManagedAccessor)accessor;
        }
        throw new IllegalArgumentException("Accessor for type " + String.valueOf(type) + " is not a ManagedAccessor");
    }

    private static Object deserialize(ITypedPayload<?> payload, Class<?> type, ManagedAccessor accessor) {
        ManagedHolder<?> cache = ManagedHolder.ofType(type);
        accessor.writeManagedField(AccessorOp.PERSISTED, cache, payload);
        return cache.value();
    }

    private static ITypedPayload<?> serialize(Object value, ManagedAccessor accessor) {
        ManagedHolder<Object> cache = ManagedHolder.of(value);
        return accessor.readManagedField(AccessorOp.PERSISTED, cache);
    }

    public String getName() {
        return this.name;
    }
}

