/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item;

import com.lowdragmc.lowdraglib.misc.PlayerInventoryTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.forge.ItemTransferHelperImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemTransferHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IItemTransfer getItemTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        void var2_2;
        void var1_1;
        return ItemTransferHelperImpl.getItemTransfer(level, (BlockPos)var1_1, (Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void exportToTarget(IItemTransfer source, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ItemTransferHelperImpl.exportToTarget(source, (int)var1_1, (Predicate<ItemStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void importToTarget(IItemTransfer target, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ItemTransferHelperImpl.importToTarget(target, (int)var1_1, (Predicate<ItemStack>)var2_2, (Level)var3_3, (BlockPos)var4_4, (Direction)var5_5);
    }

    public static boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (!first.m_41619_() && ItemStack.m_41656_((ItemStack)first, (ItemStack)second) && first.m_41782_() == second.m_41782_()) {
            return !first.m_41782_() || first.m_41783_().equals((Object)second.m_41783_());
        }
        return false;
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int size) {
        if (size == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    @Nonnull
    public static ItemStack insertItem(IItemTransfer dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Nonnull
    public static ItemStack insertItemStacked(IItemTransfer inventory, ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return ItemTransferHelper.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; !(i >= sizeInventory || ItemTransferHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
        }
        if (!stack.m_41619_()) {
            for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).m_41619_() && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
            }
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || b.m_41619_() || a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (!a.m_41753_()) {
            return false;
        }
        if (a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    public static void giveItemToPlayer(Player player, ItemStack stack) {
        ItemTransferHelper.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(Player player, @Nonnull ItemStack stack, int preferredSlot) {
        if (stack.m_41619_()) {
            return;
        }
        PlayerInventoryTransfer inventory = new PlayerInventoryTransfer(player.m_150109_());
        Level level = player.m_9236_();
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.m_41619_()) {
            remainder = ItemTransferHelper.insertItemStacked(inventory, remainder, false);
        }
        if (remainder.m_41619_() || remainder.m_41613_() != stack.m_41613_()) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.m_41619_() && !level.f_46443_) {
            ItemEntity entityitem = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), remainder);
            entityitem.m_32010_(40);
            entityitem.m_20256_(entityitem.m_20184_().m_82542_(0.0, 1.0, 0.0));
            level.m_7967_((Entity)entityitem);
        }
    }
}

