/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="phantom_item_slot", group="widget.container")
public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget,
IConfigurableWidget {
    private boolean clearSlotOnRightClick;
    @Configurable(name="ldlib.gui.editor.name.maxStackSize")
    @NumberRange(range={0.0, 64.0})
    private int maxStackSize = 64;

    public PhantomSlotWidget() {
    }

    public PhantomSlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        super(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @Override
    @ConfigSetter(field="canTakeItems")
    public PhantomSlotWidget setCanTakeItems(boolean v) {
        return this;
    }

    @Override
    @ConfigSetter(field="canPutItems")
    public PhantomSlotWidget setCanPutItems(boolean v) {
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slotReference != null && this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (this.isClientSideWidget && !this.gui.getModularUIContainer().m_142621_().m_41619_()) {
                this.slotReference.m_5852_(this.gui.getModularUIContainer().m_142621_());
            } else if (button == 1 && this.clearSlotOnRightClick && !this.slotReference.m_7993_().m_41619_()) {
                this.slotReference.m_5852_(ItemStack.f_41583_);
                this.writeClientAction(2, buf -> {});
            } else {
                HOVER_SLOT = this.slotReference;
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
                HOVER_SLOT = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, Player player) {
        if (this.slotReference != null && this.gui != null) {
            ItemStack stackHeld = this.gui.getModularUIContainer().m_142621_();
            return this.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canTakeStack(Player player) {
        return false;
    }

    @Override
    public boolean canPutStack(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
            EmiStack itemEmiStack = (EmiStack)ingredient;
            Item item = (Item)itemEmiStack.getKeyOfType(Item.class);
            Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)itemEmiStack.getAmount());
            if (ingredient instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)ingredient;
                itemStack.m_41751_(itemEmiStack.getNbt());
            }
        }
        if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient) {
            ITypedIngredient itemJeiStack = (ITypedIngredient)ingredient;
            ingredient = itemJeiStack.getItemStack().orElse(ItemStack.f_41583_);
        }
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rect2i rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new Target[]{new Target(){

            @Override
            @Nonnull
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                ITypedIngredient itemJeiStack;
                ItemStack itemStack;
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack) {
                    EmiStack itemEmiStack = (EmiStack)ingredient;
                    Item item = (Item)itemEmiStack.getKeyOfType(Item.class);
                    Object object = ingredient = item == null ? null : new ItemStack((ItemLike)item, (int)itemEmiStack.getAmount());
                    if (ingredient instanceof ItemStack) {
                        ItemStack itemStack2 = (ItemStack)ingredient;
                        itemStack2.m_41751_(itemEmiStack.getNbt());
                    }
                }
                if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient && !(itemStack = (itemJeiStack = (ITypedIngredient)ingredient).getItemStack().orElse(ItemStack.f_41583_)).m_41619_()) {
                    ingredient = itemStack;
                }
                if (PhantomSlotWidget.this.slotReference != null && ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    long id = Minecraft.m_91087_().m_91268_().m_85439_();
                    boolean shiftDown = InputConstants.m_84830_((long)id, (int)340) || InputConstants.m_84830_((long)id, (int)340);
                    ClickType clickType = shiftDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    PhantomSlotWidget.this.slotClickPhantom(PhantomSlotWidget.this.slotReference, 0, clickType, stack);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.m_130055_(stack);
                        buffer.m_130130_(0);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (this.slotReference != null && id == 1) {
            ItemStack stackHeld = buffer.m_130267_();
            int mouseButton = buffer.m_130242_();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            this.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        } else if (this.slotReference != null && id == 2) {
            this.slotReference.m_5852_(ItemStack.f_41583_);
        }
    }

    public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
        ItemStack stack = ItemStack.f_41583_;
        ItemStack stackSlot = slot.m_7993_();
        if (!stackSlot.m_41619_()) {
            stack = stackSlot.m_41777_();
        }
        if (mouseButton == 2) {
            this.fillPhantomSlot(slot, ItemStack.f_41583_, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_()) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.m_41619_()) {
                this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else {
                if (!this.areItemsEqual(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                }
                this.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        } else if (mouseButton == 5 && !slot.m_6657_()) {
            this.fillPhantomSlot(slot, stackHeld, mouseButton);
        }
        return stack;
    }

    private void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        ItemStack stackSlot = slot.m_7993_();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.m_41613_() + 1) / 2 : stackSlot.m_41613_() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.m_41613_() - 1 : stackSlot.m_41613_() + 1;
        }
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        stackSlot.m_41764_(Math.min(this.maxStackSize, stackSize));
        slot.m_5852_(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (stackHeld.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(Math.min(this.maxStackSize, stackSize));
        slot.m_5852_(phantomStack);
    }

    public boolean areItemsEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStack.m_41728_((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    public boolean isClearSlotOnRightClick() {
        return this.clearSlotOnRightClick;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }
}

