/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ModularUI {
    private final HashMap<Slot, SlotWidget> slotMap = new LinkedHashMap<Slot, SlotWidget>();
    public final WidgetGroup mainGroup;
    private int screenWidth;
    private int screenHeight;
    private int width;
    private int height;
    private boolean fullScreen;
    @OnlyIn(value=Dist.CLIENT)
    private ModularUIGuiContainer guiContainer;
    private ModularUIContainer container;
    private final List<Runnable> uiCloseCallback;
    private long tickCount;
    public final IUIHolder holder;
    public final Player entityPlayer;

    public ModularUI(Size size, IUIHolder holder, Player entityPlayer) {
        this(new WidgetGroup(Position.ORIGIN, size), holder, entityPlayer);
    }

    public ModularUI(int width, int height, IUIHolder holder, Player entityPlayer) {
        this(new Size(width, height), holder, entityPlayer);
    }

    public ModularUI(WidgetGroup mainGroup, IUIHolder holder, Player entityPlayer) {
        this.mainGroup = mainGroup;
        mainGroup.setSelfPosition(Position.ORIGIN);
        this.width = mainGroup.getSize().width;
        this.height = mainGroup.getSize().height;
        this.holder = holder;
        this.entityPlayer = entityPlayer;
        this.uiCloseCallback = new ArrayList<Runnable>();
    }

    public ModularUI(IUIHolder holder, Player entityPlayer) {
        this(0, 0, holder, entityPlayer);
        this.fullScreen = true;
    }

    public void setFullScreen() {
        this.fullScreen = true;
        this.setSize(this.getScreenWidth(), this.getScreenHeight());
    }

    @Nullable
    public Widget getFirstWidgetById(String regex) {
        return this.mainGroup.getFirstWidgetById(Pattern.compile(regex));
    }

    public List<Widget> getWidgetsById(String regex) {
        return this.mainGroup.getWidgetsById(Pattern.compile(regex));
    }

    public ModularUIContainer getModularUIContainer() {
        return this.container;
    }

    public void addNativeSlot(Slot slotHandle, SlotWidget slotWidget) {
        if (this.slotMap.containsKey(slotHandle)) {
            LDLib.LOGGER.error("duplicated slot {}, {}", (Object)slotHandle, (Object)slotWidget);
        }
        this.slotMap.put(slotHandle, slotWidget);
        if (this.container != null) {
            this.container.m_38897_(slotHandle);
        }
    }

    public void removeNativeSlot(Slot slotHandle) {
        if (this.slotMap.containsKey(slotHandle)) {
            this.slotMap.remove(slotHandle);
            if (this.container != null) {
                this.container.removeSlot(slotHandle);
            }
        }
    }

    public void setModularUIContainer(ModularUIContainer container) {
        this.container = container;
        for (Slot slot : this.slotMap.keySet()) {
            this.container.m_38897_(slot);
        }
    }

    public void registerCloseListener(Runnable runnable) {
        this.uiCloseCallback.add(runnable);
    }

    public void triggerCloseListeners() {
        this.uiCloseCallback.forEach(Runnable::run);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModularUIGuiContainer getModularUIGui() {
        return this.guiContainer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setModularUIGui(ModularUIGuiContainer modularUIGuiContainer) {
        this.guiContainer = modularUIGuiContainer;
    }

    public List<Widget> getFlatVisibleWidgetCollection() {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (Widget widget : this.mainGroup.widgets) {
            if (!widget.isVisible()) continue;
            widgetList.add(widget);
            if (!(widget instanceof WidgetGroup)) continue;
            widgetList.addAll(((WidgetGroup)widget).getContainedWidgets(false));
        }
        return widgetList;
    }

    void addTick() {
        ++this.tickCount;
    }

    public List<Widget> getFlatWidgetCollection() {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (Widget widget : this.mainGroup.widgets) {
            widgetList.add(widget);
            if (!(widget instanceof WidgetGroup)) continue;
            widgetList.addAll(((WidgetGroup)widget).getContainedWidgets(true));
        }
        return widgetList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.mainGroup.setSize(new Size(width, height));
            if (this.getModularUIGui() != null) {
                this.getModularUIGui().m_7856_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateScreenSize(int screenWidth, int screenHeight) {
        if (this.fullScreen && (screenWidth != this.width || screenHeight != this.height)) {
            this.width = screenWidth;
            this.height = screenHeight;
            if (this.getModularUIGui() != null) {
                this.getModularUIGui().m_7856_();
            }
            return;
        }
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        Position displayOffset = new Position(this.getGuiLeft(), this.getGuiTop());
        this.mainGroup.setParentPosition(displayOffset);
        this.mainGroup.onScreenSizeUpdate(screenWidth, screenHeight);
    }

    public void initWidgets() {
        this.mainGroup.setGui(this);
        this.mainGroup.initWidget();
    }

    public int getGuiLeft() {
        return (this.getScreenWidth() - this.getWidth()) / 2;
    }

    public int getGuiTop() {
        return (this.getScreenHeight() - this.getHeight()) / 2;
    }

    public Rectangle toScreenCoords(Rectangle widgetRect) {
        return new Rectangle(this.getGuiLeft() + widgetRect.x, this.getGuiTop() + widgetRect.y, widgetRect.width, widgetRect.height);
    }

    public ModularUI widget(Widget widget) {
        Preconditions.checkNotNull((Object)widget);
        this.mainGroup.addWidget(widget);
        return this;
    }

    public ModularUI background(IGuiTexture ... textures) {
        this.mainGroup.setBackground(textures);
        return this;
    }

    public HashMap<Slot, SlotWidget> getSlotMap() {
        return this.slotMap;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public long getTickCount() {
        return this.tickCount;
    }
}

