/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import net.minecraft.nbt.CompoundTag;

public class PortEdge
implements IPersistedSerializable {
    @Persisted
    public String GUID;
    @Persisted
    public String inputNodeGUID;
    @Persisted
    public String outputNodeGUID;
    @Persisted
    public String inputFieldName;
    @Persisted
    public String outputFieldName;
    @Persisted
    public String inputPortIdentifier;
    @Persisted
    public String outputPortIdentifier;
    private BaseGraph owner;
    public BaseNode inputNode;
    public NodePort inputPort;
    public NodePort outputPort;
    public Object passThroughBuffer;
    public BaseNode outputNode;

    public static PortEdge createNewEdge(BaseGraph graph, NodePort inputPort, NodePort outputPort) {
        PortEdge edge = new PortEdge();
        edge.owner = graph;
        edge.GUID = graph.newGUID().toString();
        edge.inputNode = inputPort.owner;
        edge.inputFieldName = inputPort.fieldName;
        edge.outputNode = outputPort.owner;
        edge.outputFieldName = outputPort.fieldName;
        edge.inputPort = inputPort;
        edge.outputPort = outputPort;
        edge.inputPortIdentifier = inputPort.portData.identifier;
        edge.outputPortIdentifier = outputPort.portData.identifier;
        return edge;
    }

    public void onBeforeSerialize() {
        if (this.outputNode == null || this.inputNode == null) {
            return;
        }
        this.outputNodeGUID = this.outputNode.getGUID();
        this.inputNodeGUID = this.inputNode.getGUID();
    }

    @Override
    public CompoundTag serializeNBT() {
        this.onBeforeSerialize();
        return IPersistedSerializable.super.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        IPersistedSerializable.super.deserializeNBT(tag);
    }

    public PortEdge copy() {
        PortEdge edge = new PortEdge();
        edge.deserializeNBT(this.serializeNBT());
        edge.GUID = null;
        edge.inputNodeGUID = null;
        edge.outputNodeGUID = null;
        return edge;
    }

    public void initialize(BaseGraph owner) {
        this.owner = owner;
        if (owner == null || this.inputNodeGUID == null || this.outputNodeGUID == null) {
            return;
        }
        if (!owner.nodesPerGUID.containsKey(this.outputNodeGUID) || !owner.nodesPerGUID.containsKey(this.inputNodeGUID)) {
            return;
        }
        this.outputNode = owner.nodesPerGUID.get(this.outputNodeGUID);
        this.inputNode = owner.nodesPerGUID.get(this.inputNodeGUID);
        this.inputPort = this.inputNode.getPort(this.inputFieldName, this.inputPortIdentifier);
        this.outputPort = this.outputNode.getPort(this.outputFieldName, this.outputPortIdentifier);
    }

    public String toString() {
        return "%s:%s -> %s:%s".formatted(this.outputNode.name(), this.outputPort.fieldName, this.inputNode.name(), this.inputPort.fieldName);
    }
}

