/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePortContainer;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.custom.ICustomPortBehaviorDelegate;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public abstract class BaseNode
implements IPersistedSerializable,
ILDLRegister,
IConfigurable {
    @Persisted
    protected String displayName = this.name();
    protected int titleColor;
    @Persisted
    private String GUID;
    @Persisted
    protected int computeOrder;
    @Persisted
    public Position position;
    @Persisted
    public boolean expanded;
    @Persisted
    public boolean canBeRemoved;
    protected boolean canProcess;
    protected BaseGraph graph;
    public final NodePortContainer.NodeInputPortContainer inputPorts;
    public final NodePortContainer.NodeOutputPortContainer outputPorts;
    public Runnable onProcessed;
    public Consumer<PortEdge> onAfterEdgeConnected;
    public Consumer<PortEdge> onAfterEdgeDisconnected;
    public Consumer<String> onPortsUpdated;
    private final Map<String, NodeFieldInformation> nodeFields;
    private final Stack<PortUpdate> fieldsToUpdate;
    private final HashSet<PortUpdate> updatedFields;

    protected BaseNode() {
        this.titleColor = ColorPattern.GRAY.color;
        this.computeOrder = -1;
        this.expanded = true;
        this.canBeRemoved = true;
        this.canProcess = true;
        this.inputPorts = new NodePortContainer.NodeInputPortContainer(this);
        this.outputPorts = new NodePortContainer.NodeOutputPortContainer(this);
        this.nodeFields = new LinkedHashMap<String, NodeFieldInformation>();
        this.fieldsToUpdate = new Stack();
        this.updatedFields = new HashSet();
        this.InitializeInOutDatas();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = IPersistedSerializable.super.serializeNBT();
        tag.m_128359_("_type", this.name());
        return tag;
    }

    public static BaseNode createFromTag(CompoundTag tag) {
        String type = tag.m_128461_("_type");
        AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode> wrapper = AnnotationDetector.REGISTER_GP_NODES.get(type);
        if (wrapper == null) {
            LDLib.LOGGER.error("Cannot find node type: " + type);
            return null;
        }
        BaseNode node = wrapper.creator().get();
        node.deserializeNBT(tag);
        return node;
    }

    public BaseNode copy() {
        BaseNode newNode = BaseNode.createFromTag(this.serializeNBT());
        newNode.GUID = null;
        return newNode;
    }

    @Nullable
    public static <T extends BaseNode> T createFromType(Class<T> nodeType, Position position) {
        if (!BaseNode.class.isAssignableFrom(nodeType)) {
            return null;
        }
        try {
            BaseNode node = (BaseNode)nodeType.getConstructor(new Class[0]).newInstance(new Object[0]);
            node.position = position;
            return (T)node;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getMinWidth() {
        return 50;
    }

    public void newGuid(BaseGraph graph) {
        this.GUID = graph.newGUID().toString();
    }

    public void disableInternal() {
        this.inputPorts.clear();
        this.outputPorts.clear();
        this.disable();
    }

    public void destroyInternal() {
        this.destroy();
    }

    public Field[] getAllFields() {
        return this.getClass().getFields();
    }

    public Method[] getAllMethods() {
        return this.getClass().getMethods();
    }

    protected void InitializeInOutDatas() {
        Field[] fields = this.getAllFields();
        Method[] methods = this.getAllMethods();
        ArrayList<NodeFieldInformation> fieldInformations = new ArrayList<NodeFieldInformation>();
        for (Field field : fields) {
            InputPort inputPort = field.isAnnotationPresent(InputPort.class) ? field.getAnnotation(InputPort.class) : null;
            OutputPort outputPort = field.isAnnotationPresent(OutputPort.class) ? field.getAnnotation(OutputPort.class) : null;
            boolean isMultiple = false;
            boolean input = false;
            String name = field.getName();
            int color = -1;
            int priority = 0;
            String[] tooltips = null;
            if (inputPort == null && outputPort == null) continue;
            if (inputPort != null && outputPort != null) {
                LDLib.LOGGER.error("Field " + field.getName() + " cannot be both input and output");
                continue;
            }
            input = inputPort != null;
            isMultiple = input ? inputPort.allowMultiple() : outputPort.allowMultiple();
            String[] stringArray = tooltips = input ? inputPort.tips() : outputPort.tips();
            if (input) {
                name = inputPort.name().isEmpty() ? name : inputPort.name();
                color = inputPort.color();
                priority = inputPort.priority();
            } else {
                name = outputPort.name().isEmpty() ? name : outputPort.name();
                color = outputPort.color();
                priority = outputPort.priority();
            }
            fieldInformations.add(new NodeFieldInformation(field, name, color, input, isMultiple, tooltips, priority, null));
        }
        fieldInformations.sort(Comparator.comparingInt(f -> f.priority));
        fieldInformations.forEach(f -> this.nodeFields.put(f.info.getName(), (NodeFieldInformation)f));
        for (AccessibleObject accessibleObject : methods) {
            if (!accessibleObject.isAnnotationPresent(CustomPortBehavior.class)) continue;
            CustomPortBehavior customPortBehavior = ((Method)accessibleObject).getAnnotation(CustomPortBehavior.class);
            String fieldName = customPortBehavior.field();
            if (this.nodeFields.containsKey(fieldName)) {
                NodeFieldInformation fieldInfo = this.nodeFields.get(fieldName);
                ((Method)accessibleObject).setAccessible(true);
                fieldInfo.behavior = arg_0 -> this.lambda$InitializeInOutDatas$2((Method)accessibleObject, arg_0);
                continue;
            }
            LDLib.LOGGER.error("Invalid field name for custom port behavior: " + String.valueOf(accessibleObject) + ", " + customPortBehavior.field());
        }
    }

    public void onEdgeConnected(PortEdge edge) {
        boolean input = edge.inputNode == this;
        NodePortContainer portCollection = input ? this.inputPorts : this.outputPorts;
        portCollection.add(edge);
        this.updateAllPorts();
        if (this.onAfterEdgeConnected != null) {
            this.onAfterEdgeConnected.accept(edge);
        }
    }

    protected boolean canResetPort(NodePort port) {
        return true;
    }

    public void onEdgeDisconnected(PortEdge edge) {
        if (edge == null) {
            return;
        }
        boolean input = edge.inputNode == this;
        NodePortContainer portCollection = input ? this.inputPorts : this.outputPorts;
        portCollection.remove(edge);
        boolean haveConnectedEdges = edge.inputNode.inputPorts.stream().filter(p -> Objects.equals(p.fieldName, edge.inputFieldName)).anyMatch(p -> !p.getEdges().isEmpty());
        if (edge.inputNode == this && !haveConnectedEdges && this.canResetPort(edge.inputPort) && edge.inputPort != null) {
            edge.inputPort.resetToDefault();
        }
        this.updateAllPorts();
        if (this.onAfterEdgeDisconnected != null) {
            this.onAfterEdgeDisconnected.accept(edge);
        }
    }

    public void onProcess() {
        this.inputPorts.PullDatas();
        this.process();
        if (this.onProcessed != null) {
            this.onProcessed.run();
        }
        this.outputPorts.PushDatas();
    }

    public void resetNode() {
    }

    public void initialize(BaseGraph graph) {
        this.graph = graph;
        if (this.GUID == null) {
            this.GUID = graph.newGUID().toString();
        } else {
            this.graph.addGUID(this.GUID);
        }
        this.enable();
        this.InitializePorts();
    }

    public void InitializePorts() {
        for (Map.Entry<String, NodeFieldInformation> entry : this.nodeFields.entrySet()) {
            NodeFieldInformation nodeField = entry.getValue();
            if (this.hasCustomBehavior(nodeField)) {
                this.updatePortsForField(nodeField.fieldName, false);
                continue;
            }
            PortData port = new PortData().displayName(nodeField.name).portColor(nodeField.color).acceptMultipleEdges(nodeField.isMultiple).tooltip(Arrays.stream(nodeField.tooltips).toList());
            this.addPort(nodeField.input, nodeField.fieldName, port);
        }
    }

    public boolean updateAllPorts() {
        boolean changed = false;
        for (Map.Entry<String, NodeFieldInformation> entry : this.nodeFields.entrySet()) {
            changed |= this.updatePortsForField(entry.getValue().fieldName);
        }
        return changed;
    }

    public boolean UpdateAllPortsLocal() {
        boolean changed = false;
        for (Map.Entry<String, NodeFieldInformation> entry : this.nodeFields.entrySet()) {
            changed |= this.updatePortsForFieldLocal(entry.getValue().fieldName);
        }
        return changed;
    }

    public boolean updatePortsForFieldLocal(String fieldName) {
        return this.updatePortsForFieldLocal(fieldName, true);
    }

    public boolean updatePortsForFieldLocal(String fieldName, boolean sendPortUpdatedEvent) {
        boolean changed = false;
        if (!this.nodeFields.containsKey(fieldName)) {
            return false;
        }
        NodeFieldInformation fieldInfo = this.nodeFields.get(fieldName);
        if (!this.hasCustomBehavior(fieldInfo)) {
            return false;
        }
        ArrayList<String> finalPorts = new ArrayList<String>();
        NodePortContainer portCollection = fieldInfo.input ? this.inputPorts : this.outputPorts;
        List<NodePort> nodePorts = portCollection.stream().filter(p -> Objects.equals(p.fieldName, fieldName)).toList();
        List<PortEdge> edges = nodePorts.stream().flatMap(port -> port.getEdges().stream()).toList();
        if (fieldInfo.behavior != null) {
            for (PortData portData : fieldInfo.behavior.handle(edges)) {
                changed |= this.addPortData(nodePorts, fieldInfo, finalPorts, fieldName, portData);
            }
        }
        if (!nodePorts.isEmpty()) {
            ArrayList<NodePort> currentPortsCopy = new ArrayList<NodePort>(nodePorts);
            for (NodePort currentPort : currentPortsCopy) {
                if (!finalPorts.stream().noneMatch(id -> Objects.equals(id, currentPort.portData.identifier))) continue;
                this.removePort(fieldInfo.input, currentPort);
                changed = true;
            }
        }
        for (PortEdge portEdge : edges) {
            NodePort previousPort;
            if (fieldInfo.input) {
                previousPort = portEdge.inputPort;
                portEdge.inputPort = this.getPort(fieldName, portEdge.inputPortIdentifier);
                if (previousPort == portEdge.inputPort) continue;
                if (previousPort != null) {
                    previousPort.remove(portEdge);
                }
                if (portEdge.inputPort != null) {
                    portEdge.inputPort.add(portEdge);
                    continue;
                }
                this.graph.disconnect(portEdge.GUID);
                continue;
            }
            previousPort = portEdge.outputPort;
            portEdge.outputPort = this.getPort(fieldName, portEdge.outputPortIdentifier);
            if (previousPort == portEdge.outputPort) continue;
            if (previousPort != null) {
                previousPort.remove(portEdge);
            }
            if (portEdge.outputPort != null) {
                portEdge.outputPort.add(portEdge);
                continue;
            }
            this.graph.disconnect(portEdge.GUID);
        }
        portCollection.sort((p1, p2) -> {
            int p1Index = -1;
            int p2Index = -1;
            for (int i = 0; i < finalPorts.size(); ++i) {
                if (Objects.equals(p1.portData.identifier, finalPorts.get(i))) {
                    p1Index = i;
                }
                if (Objects.equals(p2.portData.identifier, finalPorts.get(i))) {
                    p2Index = i;
                }
                if (p1Index != -1 && p2Index != -1) break;
            }
            if (p1Index == -1 || p2Index == -1) {
                return 0;
            }
            return Integer.compare(p1Index, p2Index);
        });
        if (sendPortUpdatedEvent && this.onPortsUpdated != null) {
            this.onPortsUpdated.accept(fieldName);
        }
        return changed;
    }

    private boolean addPortData(List<NodePort> nodePorts, NodeFieldInformation fieldInfo, List<String> finalPorts, String fieldName, PortData portData) {
        boolean changed = false;
        NodePort port = nodePorts.stream().filter(n -> Objects.equals(n.portData.identifier, portData.identifier)).findFirst().orElse(null);
        if (port == null) {
            this.addPort(fieldInfo.input, fieldName, portData);
            changed = true;
        } else {
            if (!BaseGraph.areTypesConnectable(port.portData.displayType, portData.displayType)) {
                ArrayList<PortEdge> copiedEdges = new ArrayList<PortEdge>(port.getEdges());
                for (PortEdge edge : copiedEdges) {
                    this.graph.disconnect(edge.GUID);
                }
            }
            if (port.portData != portData) {
                port.portData.CopyFrom(portData);
                changed = true;
            }
        }
        finalPorts.add(portData.identifier);
        return changed;
    }

    protected boolean hasCustomBehavior(NodeFieldInformation info) {
        return info.behavior != null;
    }

    public boolean updatePortsForField(String fieldName) {
        return this.updatePortsForField(fieldName, true);
    }

    public boolean updatePortsForField(String fieldName, boolean sendPortUpdatedEvent) {
        boolean changed = false;
        this.fieldsToUpdate.clear();
        this.updatedFields.clear();
        this.fieldsToUpdate.push(new PortUpdate(List.of(fieldName), this));
        while (!this.fieldsToUpdate.isEmpty()) {
            PortUpdate portUpdate = this.fieldsToUpdate.pop();
            List<String> fields = portUpdate.fieldNames;
            BaseNode node = portUpdate.node;
            if (this.updatedFields.contains(portUpdate)) continue;
            this.updatedFields.add(new PortUpdate(new ArrayList<String>(fields), node));
            for (String field : fields) {
                if (!node.updatePortsForFieldLocal(field, sendPortUpdatedEvent)) continue;
                for (NodePort port : node.isFieldInput(field) ? node.inputPorts : node.outputPorts) {
                    if (!Objects.equals(port.fieldName, field)) continue;
                    for (PortEdge edge : port.getEdges()) {
                        BaseNode edgeNode = node.isFieldInput(field) ? edge.outputNode : edge.inputNode;
                        List<String> fieldsWithBehavior = edgeNode.nodeFields.values().stream().filter(this::hasCustomBehavior).map(f -> f.fieldName).toList();
                        this.fieldsToUpdate.push(new PortUpdate(fieldsWithBehavior, edgeNode));
                    }
                }
                changed = true;
            }
        }
        return changed;
    }

    public void addPort(boolean input, String fieldName, PortData portData) {
        if (portData.displayType == null) {
            portData.displayType = this.nodeFields.get((Object)fieldName).info.getType();
        }
        if (input) {
            try {
                this.inputPorts.add(new NodePort(this, fieldName, portData));
            }
            catch (NoSuchFieldException e) {
                LDLib.LOGGER.error("Error while adding input port field:{}, data:{}", new Object[]{fieldName, portData, e});
            }
        } else {
            try {
                this.outputPorts.add(new NodePort(this, fieldName, portData));
            }
            catch (NoSuchFieldException e) {
                LDLib.LOGGER.error("Error while adding output port field:{}, data:{}", new Object[]{fieldName, portData, e});
            }
        }
    }

    public void removePort(boolean input, NodePort port) {
        if (input) {
            this.inputPorts.remove(port);
        } else {
            this.outputPorts.remove(port);
        }
    }

    public void removePort(boolean input, String fieldName) {
        if (input) {
            this.inputPorts.removeIf(p -> Objects.equals(p.fieldName, fieldName));
        } else {
            this.outputPorts.removeIf(p -> Objects.equals(p.fieldName, fieldName));
        }
    }

    public List<BaseNode> getInputNodes() {
        return this.inputPorts.stream().flatMap(p -> p.getEdges().stream()).map(e -> e.outputNode).toList();
    }

    public List<BaseNode> GetOutputNodes() {
        return this.outputPorts.stream().flatMap(p -> p.getEdges().stream()).map(e -> e.inputNode).toList();
    }

    public BaseNode findInDependencies(Predicate<BaseNode> condition) {
        Stack<BaseNode> dependencies = new Stack<BaseNode>();
        dependencies.push(this);
        int depth = 0;
        while (!dependencies.isEmpty()) {
            BaseNode node = (BaseNode)dependencies.pop();
            if (++depth > 2000) break;
            if (condition.test(node)) {
                return node;
            }
            for (BaseNode dep : node.getInputNodes()) {
                dependencies.push(dep);
            }
        }
        return null;
    }

    @Nullable
    public NodePort getPort(String fieldName, String identifier) {
        ArrayList<NodePort> ports = new ArrayList<NodePort>(this.inputPorts);
        ports.addAll(this.outputPorts);
        return ports.stream().filter(p -> {
            boolean bothNull = !(identifier != null && !identifier.isEmpty() || p.portData.identifier != null && !p.portData.identifier.isEmpty());
            return Objects.equals(p.fieldName, fieldName) && (bothNull || Objects.equals(identifier, p.portData.identifier));
        }).findFirst().orElse(null);
    }

    @Nullable
    public NodePort getPort(String fieldName) {
        return this.getPort(fieldName, null);
    }

    public List<NodePort> getAllPorts() {
        ArrayList<NodePort> ports = new ArrayList<NodePort>(this.inputPorts);
        ports.addAll(this.outputPorts);
        return ports;
    }

    public List<PortEdge> getAllEdges() {
        ArrayList<PortEdge> edges = new ArrayList<PortEdge>();
        for (NodePort port : this.getAllPorts()) {
            edges.addAll(port.getEdges());
        }
        return edges;
    }

    public boolean isFieldInput(String fieldName) {
        return this.nodeFields.get((Object)fieldName).input;
    }

    protected void enable() {
    }

    protected void disable() {
    }

    protected void destroy() {
    }

    protected void process() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public String getGUID() {
        return this.GUID;
    }

    public int getComputeOrder() {
        return this.computeOrder;
    }

    public Position getPosition() {
        return this.position;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isCanBeRemoved() {
        return this.canBeRemoved;
    }

    public boolean isCanProcess() {
        return this.canProcess;
    }

    public BaseGraph getGraph() {
        return this.graph;
    }

    public NodePortContainer.NodeInputPortContainer getInputPorts() {
        return this.inputPorts;
    }

    public NodePortContainer.NodeOutputPortContainer getOutputPorts() {
        return this.outputPorts;
    }

    public Runnable getOnProcessed() {
        return this.onProcessed;
    }

    public Consumer<PortEdge> getOnAfterEdgeConnected() {
        return this.onAfterEdgeConnected;
    }

    public Consumer<PortEdge> getOnAfterEdgeDisconnected() {
        return this.onAfterEdgeDisconnected;
    }

    public Consumer<String> getOnPortsUpdated() {
        return this.onPortsUpdated;
    }

    public Map<String, NodeFieldInformation> getNodeFields() {
        return this.nodeFields;
    }

    public Stack<PortUpdate> getFieldsToUpdate() {
        return this.fieldsToUpdate;
    }

    public HashSet<PortUpdate> getUpdatedFields() {
        return this.updatedFields;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void setCanBeRemoved(boolean canBeRemoved) {
        this.canBeRemoved = canBeRemoved;
    }

    private /* synthetic */ List lambda$InitializeInOutDatas$2(Method method, List edges) {
        try {
            return (List)method.invoke((Object)this, edges);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while invoking custom port behavior", e);
        }
    }

    public static class NodeFieldInformation {
        public String name;
        public String fieldName;
        public Field info;
        public boolean input;
        public int color;
        public boolean isMultiple;
        public String[] tooltips;
        @Nullable
        public ICustomPortBehaviorDelegate behavior;
        public int priority;

        public NodeFieldInformation(Field info, String name, int color, boolean input, boolean isMultiple, String[] tooltips, int priority, @Nullable ICustomPortBehaviorDelegate behavior) {
            this.input = input;
            this.color = color;
            this.isMultiple = isMultiple;
            this.info = info;
            this.name = name;
            this.fieldName = info.getName();
            this.behavior = behavior;
            this.tooltips = tooltips;
            this.priority = priority;
        }
    }

    private record PortUpdate(List<String> fieldNames, BaseNode node) {
    }
}

