/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.mojang.datafixers.util.Either;
import java.io.File;

public class TexturesResourceContainer
extends ResourceContainer<IGuiTexture, ImageWidget> {
    public TexturesResourceContainer(Resource<IGuiTexture> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setWidgetSupplier(k -> new ImageWidget(0, 0, 30, 30, (IGuiTexture)this.getResource().getResource((Either<String, File>)k)));
        this.setDragging((Either<String, File> key) -> new UIResourceTexture(resource, (Either<String, File>)key), (D o) -> o);
        this.setOnEdit(key -> this.openTextureConfigurator((Either<String, File>)key, (IGuiTexture)this.getResource().getResource((Either<String, File>)key)));
        this.setCanEdit(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setCanGlobalChange(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setCanRemove(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setOnMenu((selected, m) -> m.branch(Icons.ADD_FILE, "ldlib.gui.editor.menu.add_resource", menu -> {
            for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper : AnnotationDetector.REGISTER_TEXTURES) {
                IGuiTexture icon = wrapper.creator().get();
                String name = "ldlib.gui.editor.register.texture." + wrapper.annotation().name();
                menu.leaf(icon, name, () -> {
                    resource.addBuiltinResource(this.genNewFileName(), (IGuiTexture)wrapper.creator().get());
                    this.reBuild();
                });
            }
        }));
    }

    private void openTextureConfigurator(final Either<String, File> key, final IGuiTexture current) {
        if (this.resource.getResourceName(key).equals("empty")) {
            return;
        }
        this.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, new IConfigurable(){

            @Override
            public void buildConfigurator(ConfiguratorGroup father) {
                AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> defaultWrapper = null;
                for (AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> wrapper2 : AnnotationDetector.REGISTER_TEXTURES) {
                    if (wrapper2.clazz() != current.getClass()) continue;
                    defaultWrapper = wrapper2;
                }
                AnnotationDetector.Wrapper<LDLRegister, IGuiTexture> finalDefaultWrapper = defaultWrapper;
                SelectorConfigurator<AnnotationDetector.Wrapper> selectorConfigurator = new SelectorConfigurator<AnnotationDetector.Wrapper>("ldlib.gui.editor.name.texture_type", () -> finalDefaultWrapper, wrapper -> {
                    if (wrapper != finalDefaultWrapper) {
                        IGuiTexture newTexture = (IGuiTexture)wrapper.creator().get();
                        TexturesResourceContainer.this.getResource().addResource((Either<String, File>)key, newTexture);
                        ((ImageWidget)TexturesResourceContainer.this.getWidgets().get(key)).setImage(newTexture);
                        TexturesResourceContainer.this.openTextureConfigurator((Either<String, File>)key, newTexture);
                    }
                }, finalDefaultWrapper, false, AnnotationDetector.REGISTER_TEXTURES, w -> "ldlib.gui.editor.register.texture." + ((LDLRegister)w.annotation()).name());
                selectorConfigurator.setTips("ldlib.gui.editor.tips.texture_type");
                father.addConfigurators(selectorConfigurator);
                current.buildConfigurator(father);
            }
        });
    }
}

