/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.runtime;

import com.google.common.base.Strings;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.ManagedFieldUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import com.lowdragmc.lowdraglib.utils.TagUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PersistedParser {
    public static void serializeNBT(CompoundTag tag, Class<?> clazz, Object object) {
        if (clazz == Object.class || clazz == null) {
            return;
        }
        PersistedParser.serializeNBT(tag, clazz.getSuperclass(), object);
        for (Field field : clazz.getDeclaredFields()) {
            Object nbt;
            String key;
            block11: {
                if (Modifier.isStatic(field.getModifiers())) continue;
                key = field.getName();
                if (field.isAnnotationPresent(Configurable.class)) {
                    Configurable configurable = field.getAnnotation(Configurable.class);
                    if (!configurable.persisted()) continue;
                    if (!Strings.isNullOrEmpty((String)configurable.key())) {
                        key = configurable.key();
                    }
                } else {
                    if (!field.isAnnotationPresent(Persisted.class)) continue;
                    Persisted persisted = field.getAnnotation(Persisted.class);
                    if (!Strings.isNullOrEmpty((String)persisted.key())) {
                        key = persisted.key();
                    }
                }
                nbt = null;
                if (field.isAnnotationPresent(Configurable.class) && field.getAnnotation(Configurable.class).subConfigurable() || field.isAnnotationPresent(Persisted.class) && field.getAnnotation(Persisted.class).subPersisted()) {
                    try {
                        field.setAccessible(true);
                        Object value = field.get(object);
                        if (value == null) break block11;
                        if (value instanceof ITagSerializable) {
                            ITagSerializable serializable = (ITagSerializable)value;
                            nbt = serializable.serializeNBT();
                            break block11;
                        }
                        nbt = new CompoundTag();
                        PersistedParser.serializeNBT((CompoundTag)nbt, ReflectionUtils.getRawType(field.getGenericType()), value);
                    }
                    catch (IllegalAccessException value) {}
                } else {
                    ManagedKey managedKey = ManagedFieldUtils.createKey(field);
                    nbt = managedKey.readPersistedField(managedKey.createRef(object));
                }
            }
            if (nbt == null) continue;
            TagUtils.setTagExtended(tag, key, nbt);
        }
    }

    public static void deserializeNBT(CompoundTag tag, Map<String, Method> setters, Class<?> clazz, Object object) {
        if (clazz == Object.class || clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            ConfigSetter configSetter;
            String name;
            if (!method.isAnnotationPresent(ConfigSetter.class) || setters.containsKey(name = (configSetter = method.getAnnotation(ConfigSetter.class)).field())) continue;
            setters.put(name, method);
        }
        PersistedParser.deserializeNBT(tag, setters, clazz.getSuperclass(), object);
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            String key = ((Field)accessibleObject).getName();
            if (accessibleObject.isAnnotationPresent(Configurable.class)) {
                Configurable configurable = ((Field)accessibleObject).getAnnotation(Configurable.class);
                if (!configurable.persisted()) continue;
                if (!Strings.isNullOrEmpty((String)configurable.key())) {
                    key = configurable.key();
                }
            } else {
                if (!accessibleObject.isAnnotationPresent(Persisted.class)) continue;
                Persisted persisted = ((Field)accessibleObject).getAnnotation(Persisted.class);
                if (!Strings.isNullOrEmpty((String)persisted.key())) {
                    key = persisted.key();
                }
            }
            Tag nbt = TagUtils.getTagExtended(tag, key);
            if (nbt == null) continue;
            if (accessibleObject.isAnnotationPresent(Configurable.class) && ((Field)accessibleObject).getAnnotation(Configurable.class).subConfigurable() || accessibleObject.isAnnotationPresent(Persisted.class) && ((Field)accessibleObject).getAnnotation(Persisted.class).subPersisted()) {
                try {
                    ((Field)accessibleObject).setAccessible(true);
                    Object value = ((Field)accessibleObject).get(object);
                    if (value == null) continue;
                    if (value instanceof ITagSerializable) {
                        ITagSerializable serializable = (ITagSerializable)value;
                        serializable.deserializeNBT(nbt);
                        continue;
                    }
                    if (!(nbt instanceof CompoundTag)) continue;
                    CompoundTag compoundTag = (CompoundTag)nbt;
                    PersistedParser.deserializeNBT(compoundTag, new HashMap<String, Method>(), ReflectionUtils.getRawType(((Field)accessibleObject).getGenericType()), value);
                }
                catch (IllegalAccessException value) {}
                continue;
            }
            ManagedKey managedKey = ManagedFieldUtils.createKey((Field)accessibleObject);
            managedKey.writePersistedField(managedKey.createRef(object), nbt);
            Method setter = setters.get(((Field)accessibleObject).getName());
            if (setter == null) continue;
            ((Field)accessibleObject).setAccessible(true);
            try {
                setter.invoke(object, ((Field)accessibleObject).get(object));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

