/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.traders.energy.settings;

import io.github.lightman314.lctech.TechText;
import io.github.lightman314.lctech.common.traders.energy.EnergyTraderData;
import io.github.lightman314.lctech.common.traders.energy.tradedata.EnergyTradeData;
import io.github.lightman314.lctech.common.util.EnergyUtil;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.LoadContext;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.trades.TradeSettings;
import io.github.lightman314.lightmanscurrency.api.traders.settings.builtin.trades.TradeSubNode;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergyTradeSettings
extends TradeSettings<EnergyTraderData> {
    public EnergyTradeSettings(EnergyTraderData trader) {
        super("fluid_trades", (TraderData)trader);
    }

    @Nullable
    protected EnergyTradeData getRuleHost(int tradeIndex) {
        return tradeIndex >= 0 && tradeIndex < ((EnergyTraderData)this.trader).getTradeCount() ? ((EnergyTraderData)this.trader).getTrade(tradeIndex) : null;
    }

    protected SettingsSubNode<?> createTradeNode(int tradeIndex) {
        return new TradeNode(this, tradeIndex);
    }

    public void saveSettings(SavedSettingData.MutableNodeAccess data) {
        data.setIntValue("trade_count", ((EnergyTraderData)this.trader).getTradeCount());
    }

    public void loadSettings(SavedSettingData.NodeAccess data, LoadContext context) {
        if (data.hasIntValue("trade_count")) {
            ((EnergyTraderData)this.trader).overrideTradeCount(data.getIntValue("trade_count"));
        }
    }

    protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
        lineWriter.accept((Component)EnergyTradeSettings.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_COUNT.get(new Object[0]), (int)data.getIntValue("trade_count")));
    }

    private static class TradeNode
    extends TradeSubNode<EnergyTradeData, EnergyTradeSettings> {
        public TradeNode(EnergyTradeSettings parent, int index) {
            super((SettingsNode)parent, index);
        }

        @Nullable
        protected EnergyTradeData getTrade() {
            return ((EnergyTradeSettings)this.parent).getRuleHost(this.index);
        }

        protected void saveTrade(SavedSettingData.MutableNodeAccess node, EnergyTradeData trade) {
            node.setStringValue("type", trade.getTradeDirection().toString());
            node.setCompoundValue("price", trade.getCost().save());
            node.setIntValue("energy", trade.getAmount());
        }

        protected void loadTrade(SavedSettingData.NodeAccess node, EnergyTradeData trade, LoadContext context) {
            trade.setTradeDirection((TradeDirection)EnumUtil.enumFromString((String)node.getStringValue("type"), (Enum[])TradeDirection.values(), (Enum)TradeDirection.SALE));
            trade.setCost(MoneyValue.load((CompoundTag)node.getCompoundValue("price")));
            trade.setAmount(node.getIntValue("energy"));
        }

        protected void writeLines(SavedSettingData.NodeAccess data, Consumer<Component> lineWriter) {
            TradeDirection type = (TradeDirection)EnumUtil.enumFromString((String)data.getStringValue("type"), (Enum[])TradeDirection.values(), (Enum)TradeDirection.SALE);
            lineWriter.accept((Component)SettingsNode.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_TYPE.get(new Object[0]), (Component)LCText.GUI_TRADE_DIRECTION.get((Object)type).get(new Object[0])));
            lineWriter.accept((Component)SettingsNode.formatEntry((Component)LCText.DATA_ENTRY_TRADER_TRADE_PRICE.get(new Object[0]), (Component)MoneyValue.load((CompoundTag)data.getCompoundValue("price")).getText()));
            lineWriter.accept((Component)SettingsNode.formatEntry((Component)TechText.DATA_ENTRY_TRADER_TRADE_ENERGY.get(new Object[0]), (String)EnergyUtil.formatEnergyAmount(data.getIntValue("energy"))));
        }
    }
}

