/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lctech.common.items;

import com.google.common.collect.Lists;
import io.github.lightman314.lctech.common.core.ModItems;
import io.github.lightman314.lctech.common.util.FluidFormatUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidShardItem
extends Item {
    public static final ResourceLocation DATA = VersionUtil.modResource((String)"lctech", (String)"fluid_shard");
    private static final List<FluidShardItem> SHARD_ITEMS = Lists.newArrayList();
    public final ResourceLocation renderData;

    @OnlyIn(value=Dist.CLIENT)
    public static List<ModelResourceLocation> getShardModelList() {
        ArrayList list = Lists.newArrayList();
        SHARD_ITEMS.forEach(shardItem -> list.add(new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)shardItem), "inventory")));
        return list;
    }

    public FluidShardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
        this.renderData = DATA;
        SHARD_ITEMS.add(this);
    }

    public FluidShardItem(Item.Properties properties, ResourceLocation renderData) {
        super(properties);
        this.renderData = renderData;
        SHARD_ITEMS.add(this);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        FluidStack fluid = FluidShardItem.GetFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)FluidFormatUtil.getFluidName(fluid));
            tooltip.add((Component)Component.m_237113_((String)(FluidFormatUtil.formatFluidAmount(fluid.getAmount()) + "mB")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (FluidShardItem.GetFluid(stack).isEmpty()) {
            stack.m_41764_(0);
        }
    }

    public static FluidStack GetFluid(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof FluidShardItem && (tag = stack.m_41784_()).m_128425_("Tank", 10)) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Tank"));
        }
        return FluidStack.EMPTY;
    }

    public static ItemStack GetFluidShard(FluidStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack returnStack = new ItemStack((ItemLike)ModItems.FLUID_SHARD.get());
        FluidShardItem.WriteTankData(returnStack, stack);
        return returnStack;
    }

    public static void WriteTankData(ItemStack stack, FluidStack tank) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("Tank", (Tag)tank.writeToNBT(new CompoundTag()));
        stack.m_41751_(tag);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag compound) {
        return new FluidShardCapability(stack);
    }

    public static class FluidShardCapability
    implements IFluidHandlerItem,
    ICapabilityProvider {
        final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        final ItemStack stack;

        private FluidStack tank() {
            return FluidShardItem.GetFluid(this.stack);
        }

        private void setTank(FluidStack tank) {
            FluidShardItem.WriteTankData(this.stack, tank);
        }

        public FluidShardCapability(ItemStack stack) {
            this.stack = stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? this.tank().copy() : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return this.getFluidInTank(tank).getAmount();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty() || !this.tank().isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)resource.getAmount(), (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
                if (tank.isEmpty()) {
                    this.getContainer().m_41774_(1);
                }
            }
            return resultStack;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.tank().isEmpty()) {
                return FluidStack.EMPTY;
            }
            int drainAmount = MathUtil.clamp((int)maxDrain, (int)0, (int)this.tank().getAmount());
            FluidStack resultStack = this.tank().copy();
            resultStack.setAmount(drainAmount);
            if (action.execute()) {
                FluidStack tank = this.tank();
                tank.shrink(drainAmount);
                if (tank.isEmpty()) {
                    tank = FluidStack.EMPTY;
                }
                this.setTank(tank);
                if (tank.isEmpty()) {
                    this.getContainer().m_41774_(1);
                }
            }
            return resultStack;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
        }
    }
}

