/*
 * Decompiled with CFR 0.152.
 */
package xyz.cryptix.kubejsalchem.utils;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.MetalType;
import com.smashingmods.chemlib.common.items.ElementItem;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

@Info(value="Utility class for querying properties of chemical elements from ItemStacks.")
public class ChemicalElement {
    @Info(value="Returns the atomic number of the element in the given ItemStack.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public int getAtomicNumber(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getAtomicNumber();
        }
        return 0;
    }

    @Info(value="Returns the abbreviation (symbol) of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public String getAbbreviation(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getAbbreviation();
        }
        return null;
    }

    @Info(value="Returns the chemical group number of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public int getGroup(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getGroup();
        }
        return 0;
    }

    @Info(value="Returns the period number of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public int getPeriod(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getPeriod();
        }
        return 0;
    }

    @Info(value="Returns the matter state of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public MatterState getMatterState(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getMatterState();
        }
        return null;
    }

    @Info(value="Returns the metal type of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public MetalType getMetalType(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getMetalType();
        }
        return null;
    }

    @Info(value="Checks if the element is artificial.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public boolean isArtificial(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).isArtificial();
        }
        return false;
    }

    @Info(value="Returns the color of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public int getColor(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getColor();
        }
        return 0;
    }

    @Info(value="Returns a list of MobEffectInstances applied to the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public List<MobEffectInstance> getEffects(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getEffects();
        }
        return null;
    }

    @Info(value="Returns the group name of the element.", params={@Param(name="itemStack", value="ItemStack containing an ElementItem")})
    public String getGroupName(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof ElementItem) {
            return ((ElementItem)itemStack.m_41720_()).getGroupName();
        }
        return null;
    }

    @Info(value="Checks if the given ItemStack is a chemical element.", params={@Param(name="itemStack", value="ItemStack to check")})
    public boolean isElement(ItemStack itemStack) {
        return itemStack != null && itemStack.m_41720_() instanceof ElementItem;
    }
}

