/*
 * Decompiled with CFR 0.152.
 */
package xyz.cryptix.kubejsalchem.utils;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.common.items.CompoundItem;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

@Info(value="Utility class for querying properties of chemical compounds from ItemStacks.")
public class ChemicalCompound {
    @Info(value="Checks if the given ItemStack is a CompoundItem.", params={@Param(name="itemStack", value="ItemStack to check")})
    public boolean isCompound(ItemStack itemStack) {
        return itemStack != null && itemStack.m_41720_() instanceof CompoundItem;
    }

    @Info(value="Returns the description of the compound.", params={@Param(name="itemStack", value="ItemStack containing a CompoundItem")})
    public String getDescription(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof CompoundItem) {
            return ((CompoundItem)itemStack.m_41720_()).getChemicalDescription();
        }
        return null;
    }

    @Info(value="Returns the matter state of the compound.", params={@Param(name="itemStack", value="ItemStack containing a CompoundItem")})
    public MatterState getMatterState(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof CompoundItem) {
            return ((CompoundItem)itemStack.m_41720_()).getMatterState();
        }
        return null;
    }

    @Info(value="Returns the color of the compound.", params={@Param(name="itemStack", value="ItemStack containing a CompoundItem")})
    public int getColor(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.m_41720_() instanceof CompoundItem) {
            return ((CompoundItem)itemStack.m_41720_()).getColor();
        }
        return 0;
    }

    @Info(value="Returns a map of components and their counts in the compound.", params={@Param(name="itemStack", value="ItemStack containing a CompoundItem")})
    public Map<String, Integer> getComponents(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof CompoundItem) {
            return ((CompoundItem)itemStack.m_41720_()).getComponents();
        }
        return null;
    }

    @Info(value="Returns a list of MobEffectInstances applied to the compound.", params={@Param(name="itemStack", value="ItemStack containing a CompoundItem")})
    public List<MobEffectInstance> getEffects(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41720_() instanceof CompoundItem) {
            return ((CompoundItem)itemStack.m_41720_()).getEffects();
        }
        return null;
    }
}

