/*
 * Decompiled with CFR 0.152.
 */
package xyz.cryptix.kubejsalchem.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.cryptix.kubejsalchem.recipes.DissolverRecipe;

public class DissolverRecipeJS
extends RecipeJS {
    private final List<Group> groups = new ArrayList<Group>();

    public DissolverRecipeJS withGroup(double probability, OutputItem[] items) {
        this.groups.add(new Group(probability, items));
        return this;
    }

    public void serialize() {
        super.serialize();
        this.json.addProperty("group", "alchemistry:dissolver");
        JsonArray groupsArr = new JsonArray();
        for (Group group : this.groups) {
            groupsArr.add((JsonElement)group.toJson());
        }
        JsonObject output = new JsonObject();
        output.add("groups", (JsonElement)groupsArr);
        output.addProperty("rolls", (Number)this.getValue(DissolverRecipe.ROLLS));
        output.addProperty("weighted", (Boolean)this.getValue(DissolverRecipe.WEIGHTED));
        this.json.remove("rolls");
        this.json.remove("weighted");
        this.json.add("output", (JsonElement)output);
    }

    public InputItem readInputItem(Object from) {
        if (from instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)from;
            int count = jsonObj.has("count") ? jsonObj.get("count").getAsInt() : 1;
            return InputItem.of((Object)jsonObj.getAsJsonObject("ingredient")).withCount(count);
        }
        return super.readInputItem(from);
    }

    public JsonElement writeInputItem(InputItem value) {
        JsonObject o = new JsonObject();
        o.addProperty("count", (Number)value.count);
        o.add("ingredient", value.ingredient.m_43942_());
        return o;
    }

    public static class Group {
        public double probability;
        public OutputItem[] results;

        public Group(double probability, OutputItem[] results) {
            this.probability = probability;
            this.results = results;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("probability", (Number)this.probability);
            JsonArray arr = new JsonArray();
            for (OutputItem outputItem : this.results) {
                JsonObject r = new JsonObject();
                String outputItemName = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)outputItem.item.m_41720_())).toString();
                r.addProperty("item", outputItemName);
                if (outputItem.getCount() > 1) {
                    r.addProperty("count", (Number)outputItem.getCount());
                }
                arr.add((JsonElement)r);
            }
            json.add("results", (JsonElement)arr);
            return json;
        }
    }
}

