/*
 * Decompiled with CFR 0.152.
 */
package xyz.cryptix.kubejsalchem.custom;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.MetalType;
import com.smashingmods.chemlib.common.items.ElementItem;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.cryptix.kubejsalchem.KubeJSAlchem;

@Info(value="Builder class for creating custom chemical elements in KubeJSAlchem. Allows setting atomic number, abbreviation, group, period, matter state, metal type, artificial flag, color, and effects.")
public class ElementItemBuilder
extends ItemBuilder {
    private int atomicNumber;
    private String abbreviation;
    private int group;
    private String groupName;
    private int period;
    private MatterState matter_state;
    private MetalType metal_type;
    private boolean artificial;
    private String color;
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

    public ElementItemBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="Sets the atomic number of the element.", params={@Param(name="atomicNumber", value="Integer value of the element's atomic number")})
    public ElementItemBuilder atomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
        return this;
    }

    @Info(value="Sets the abbreviation (symbol) of the element.", params={@Param(name="abbreviation", value="Element symbol: H, He...")})
    public ElementItemBuilder abbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
        return this;
    }

    @Info(value="Sets the chemical group of the element.", params={@Param(name="group", value="Integer group number")})
    public ElementItemBuilder chemicalGroup(int group) {
        this.group = group;
        return this;
    }

    @Info(value="Sets the name of the group the element belongs to.", params={@Param(name="groupName", value="String group name")})
    public ElementItemBuilder groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Info(value="Sets the period of the element in the periodic table.", params={@Param(name="period", value="Integer period number")})
    public ElementItemBuilder period(int period) {
        this.period = period;
        return this;
    }

    @Info(value="Sets the matter state of the element (SOLID, LIQUID, GAS). Uses MatterState wrapper from xyz.cryptix.kubejsalchem.utils.", params={@Param(name="matter_state", value="MatterState enum (SOLID, LIQUID, GAS)")})
    public ElementItemBuilder matterState(MatterState matter_state) {
        this.matter_state = matter_state;
        return this;
    }

    @Info(value="Sets the metal type of the element (METAL, METALLOID, NONMETAL). Uses MetalType wrapper from xyz.cryptix.kubejsalchem.utils.", params={@Param(name="metal_type", value="MetalType enum")})
    public ElementItemBuilder metalType(MetalType metal_type) {
        this.metal_type = metal_type;
        return this;
    }

    @Info(value="Sets whether the element is artificial.", params={@Param(name="artificial", value="Boolean flag")})
    public ElementItemBuilder artificial(boolean artificial) {
        this.artificial = artificial;
        return this;
    }

    @Info(value="Marks the element as artificial (shorthand method).")
    public ElementItemBuilder artificial() {
        return this.artificial(true);
    }

    @Info(value="Sets the display color of the element in hexadecimal format.", params={@Param(name="color", value="Hex color string")})
    public ElementItemBuilder elementColor(String color) {
        this.color = color;
        return this;
    }

    @Info(value="Adds a MobEffectInstance to the element.", params={@Param(name="effect", value="Minecraft effect ID"), @Param(name="duration", value="Duration in ticks"), @Param(name="amplifier", value="Effect strength")})
    public ElementItemBuilder withEffect(String effect, int duration, int amplifier) {
        this.effects.add(new MobEffectInstance(Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect))), duration, amplifier));
        return this;
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.itemModel(this.id, modelGenerator -> modelGenerator.parent("chemlib:item/builtin_entity"));
    }

    public ElementItem createObject() {
        ElementItem item = new ElementItem(this.id.m_135815_(), this.atomicNumber, this.abbreviation, this.group, this.period, this.matter_state, this.metal_type, this.artificial, this.color, this.effects);
        KubeJSAlchem.ELEMENTS.put(item, this.groupName);
        KubeJSAlchem.LOGGER.info("Successfully registered Element {}", (Object)this.id.m_135815_());
        return item;
    }
}

