/*
 * Decompiled with CFR 0.152.
 */
package xyz.cryptix.kubejsalchem.custom;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.common.items.CompoundItem;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.cryptix.kubejsalchem.KubeJSAlchem;

@Info(value="Builder class for creating custom compounds in KubeJSAlchem. Allows setting matter state, description, color, components, and effects. Automatically generates assets and registers the compound.")
public class CompoundItemBuilder
extends ItemBuilder {
    private MatterState matter_state;
    private String description;
    private String color;
    private final HashMap<String, Integer> components = new LinkedHashMap<String, Integer>();
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

    public CompoundItemBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="Sets the matter state of the compound (SOLID, LIQUID, GAS). This uses the MatterState wrapper from xyz.cryptix.kubejsalchem.utils.", params={@Param(name="matter_state", value="The matter state enum (SOLID, LIQUID, GAS) from MatterState")})
    public CompoundItemBuilder matterState(MatterState matter_state) {
        this.matter_state = matter_state;
        return this;
    }

    @Info(value="Sets a description for the compound.", params={@Param(name="description", value="Compound Description")})
    public CompoundItemBuilder description(String description) {
        this.description = description;
        return this;
    }

    @Info(value="Sets the display color of the element in hexadecimal format.", params={@Param(name="color", value="Hex color string")})
    public CompoundItemBuilder compoundColor(String color) {
        this.color = color;
        return this;
    }

    @Info(value="Adds a component with a specified count to the compound.", params={@Param(name="item", value="The item ID to add"), @Param(name="count", value="Quantity of the item")})
    public CompoundItemBuilder withComponent(String item, Integer count) {
        this.components.put(item, count);
        return this;
    }

    @Info(value="Adds a component with a default count of 1.", params={@Param(name="item", value="The item ID to add")})
    public CompoundItemBuilder withComponent(String item) {
        return this.withComponent(item, 1);
    }

    @Info(value="Adds a MobEffectInstance effect to the compound.", params={@Param(name="effect", value="Effect ID (Minecraft registry name)"), @Param(name="duration", value="Duration in ticks"), @Param(name="amplifier", value="Effect strength")})
    public CompoundItemBuilder withEffect(String effect, int duration, int amplifier) {
        this.effects.add(new MobEffectInstance(Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect))), duration, amplifier));
        return this;
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.itemModel(this.id, m -> m.parent(String.format("chemlib:item/compound_%s_model", this.matter_state.m_7912_())));
    }

    public CompoundItem createObject() {
        CompoundItem item = new CompoundItem(this.id.m_135815_(), this.matter_state, this.components, this.description, this.color, this.effects);
        KubeJSAlchem.COMPOUNDS.add(item);
        KubeJSAlchem.LOGGER.info("Successfully registered Compound {}", (Object)this.id.m_135815_());
        return item;
    }
}

