/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.client;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class ClientUtils {
    public static final int ENTITY_CREATION_INTERVAL = 3000;
    private static final Map<String, LivingEntity> ENTITY_CACHE = new HashMap<String, LivingEntity>();
    private static final Map<String, Long> CREATION_TIMES = new HashMap<String, Long>();

    public static LivingEntity doRendering(EntityType<?> entityType, boolean input, DyeColor color) {
        boolean refreshAllowed;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        String key = CommonUtils.makeKey(entityType, input, color);
        long currentTime = System.currentTimeMillis();
        LivingEntity entity = ENTITY_CACHE.get(key);
        long lastTime = CREATION_TIMES.getOrDefault(key, 0L);
        boolean bl = refreshAllowed = JustEnoughBreeding.isModLoaded("entity_model_features") == false && JustEnoughBreeding.isModLoaded("optifine") == false;
        if (entity == null) {
            entity = ClientUtils.createEntity(entityType, (Level)level, color);
            ENTITY_CACHE.put(key, entity);
            CREATION_TIMES.put(key, currentTime);
        } else if (refreshAllowed && currentTime - lastTime >= 3000L) {
            entity = ClientUtils.createEntity(entityType, (Level)level, color);
            ENTITY_CACHE.put(key, entity);
            CREATION_TIMES.put(key, currentTime);
        }
        return entity;
    }

    private static LivingEntity createEntity(EntityType<?> entityType, Level level, DyeColor color) {
        LivingEntity entity = (LivingEntity)entityType.m_20615_(level);
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            tamable.m_7105_(true);
        }
        if (color != null && entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            sheep.m_29855_(color);
        }
        return entity;
    }

    public static LivingEntity doRendering(EntityType<?> entityType) {
        return ClientUtils.doRendering(entityType, false, null);
    }
}

