/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.jeargh.utils;

import com.cwelth.jeargh.utils.ItemStackDrop;
import com.cwelth.jeargh.utils.JEARGHProfiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class JEARGHProfilerRunnable
implements Runnable {
    private final int minX;
    private final int minZ;
    private final ServerLevel level;
    private final Player player;

    public JEARGHProfilerRunnable(int minX, int minZ, ServerLevel level, Player player) {
        this.minX = minX;
        this.minZ = minZ;
        this.level = level;
        this.player = player;
    }

    @Override
    public void run() {
        this.profile();
        ++JEARGHProfiler.profiled_chunks;
        ++JEARGHProfiler.profiled_chunks_total;
        if (!JEARGHProfiler.shouldAbort) {
            int percent = JEARGHProfiler.profiled_chunks_total * 100 / JEARGHProfiler.chunks_to_profile_total;
            this.player.m_5661_((Component)Component.m_237110_((String)"profiling.progress", (Object[])new Object[]{JEARGHProfiler.profiled_chunks, JEARGHProfiler.chunks_to_profile, JEARGHProfiler.profiled_chunks_total, JEARGHProfiler.chunks_to_profile_total, percent}), true);
        }
    }

    public static void addToMap(Block block, int height, int qty) {
        HashMap data;
        if (JEARGHProfiler.collectedData.containsKey(block)) {
            data = (HashMap)JEARGHProfiler.collectedData.get(block);
            if (data.containsKey(height)) {
                data.put(height, (Integer)data.get(height) + qty);
            } else {
                data.put(height, qty);
            }
        } else {
            data = new HashMap();
            data.put(height, qty);
        }
        JEARGHProfiler.collectedData.put(block, data);
    }

    public void addToDrops(BlockState blockState, BlockPos pos) {
        if (!JEARGHProfiler.dropsMap.containsKey(blockState.m_60734_())) {
            ArrayList<ItemStackDrop> toReturn = new ArrayList<ItemStackDrop>();
            List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)this.level, (BlockPos)pos, null);
            for (ItemStack stack : drops) {
                toReturn.add(new ItemStackDrop(stack.m_41720_(), stack.m_41613_(), blockState, pos, this.level));
            }
            JEARGHProfiler.dropsMap.put(blockState.m_60734_(), toReturn);
        }
    }

    public void profile() {
        int lowestPoint = this.level.m_141937_();
        int highestPoint = this.level.m_143344_();
        for (int y = lowestPoint; y <= highestPoint; ++y) {
            for (int x = this.minX; x <= this.minX + 16; ++x) {
                for (int z = this.minZ; z <= this.minZ + 16; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState foundBlock = this.level.m_8055_(pos);
                    if (!foundBlock.m_204336_(Tags.Blocks.ORES)) continue;
                    JEARGHProfilerRunnable.addToMap(foundBlock.m_60734_(), y + 64, 1);
                    this.addToDrops(foundBlock, pos);
                }
            }
        }
    }
}

