/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.jeargh.utils;

import com.cwelth.jeargh.JEARGH;
import com.cwelth.jeargh.utils.DropCalculatorRunnable;
import com.cwelth.jeargh.utils.ItemStackDrop;
import com.cwelth.jeargh.utils.JEARGHProfilerRunnable;
import com.cwelth.jeargh.utils.WorldGenJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class JEARGHProfiler
implements Runnable {
    public static final int CHUNK_SIZE = 16;
    public static int chunk_radius_to_profile = 100;
    public static int max_threads;
    private ExecutorService executorService;
    public static int chunks_to_profile;
    public static int chunks_to_profile_total;
    public static int profiled_chunks;
    public static int profiled_chunks_total;
    public static boolean shouldAbort;
    public boolean shouldMerge = false;
    public Player player;
    public static ConcurrentMap<Block, HashMap<Integer, Integer>> collectedData;
    public static ConcurrentMap<Block, List<ItemStackDrop>> dropsMap;
    private List<WorldGenJson> worldGen = new ArrayList<WorldGenJson>();
    private List<WorldGenJson> worldGenExisting = new ArrayList<WorldGenJson>();

    public JEARGHProfiler() {
        max_threads = Runtime.getRuntime().availableProcessors() * 2;
    }

    public static String getPath() {
        File file = Minecraft.m_91087_().f_91069_;
        try {
            return file.getCanonicalFile().getPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public void cyclicRename() {
        File file_new;
        File file_old;
        int counter = 0;
        while ((file_old = new File(JEARGHProfiler.getPath() + "/config/world-gen-" + ++counter + ".json")).exists()) {
        }
        for (int ic = counter; ic > 1; --ic) {
            File file_new2;
            File file_old2 = new File(JEARGHProfiler.getPath() + "/config/world-gen-" + (ic - 1) + ".json");
            if (file_old2.renameTo(file_new2 = new File(JEARGHProfiler.getPath() + "/config/world-gen-" + ic + ".json"))) continue;
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.generate.backup.failed", (Object[])new Object[]{file_old2.getName()}));
        }
        file_old = new File(JEARGHProfiler.getPath() + "/config/world-gen.json");
        if (!file_old.renameTo(file_new = new File(JEARGHProfiler.getPath() + "/config/world-gen-1.json"))) {
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.generate.backup.failed", (Object[])new Object[]{file_old.getName()}));
        }
    }

    public void generateWorldGenFile() {
        this.player.m_213846_((Component)Component.m_237115_((String)"profiling.generate.file"));
        File file = new File(JEARGHProfiler.getPath() + "/config/world-gen.json");
        if (file.exists()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"profiling.generate.backup"));
            this.cyclicRename();
        }
        Gson builder = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter writer = new FileWriter(file);
            builder.toJson(this.worldGen, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (JsonIOException e) {
            JEARGH.LOGGER.error("Cannot save world-gen.json. " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            JEARGH.LOGGER.error("Cannot save world-gen.json. " + e.getLocalizedMessage());
        }
        this.player.m_213846_((Component)Component.m_237115_((String)"profiling.generate.done"));
    }

    public String buildItemDrops(Block block) {
        if (dropsMap.containsKey(block)) {
            Object toRet = "";
            for (ItemStackDrop drop : (List)dropsMap.get(block)) {
                String toAdd = ForgeRegistries.ITEMS.getKey((Object)drop.getItem()) + "," + drop.getChance();
                toRet = (String)toRet + (((String)toRet).isEmpty() ? toAdd : ";" + toAdd);
            }
            return toRet;
        }
        return ForgeRegistries.BLOCKS.getKey((Object)block).toString() + ",1.0";
    }

    public void dumpForDimension(String dimension) {
        for (Map.Entry ore : collectedData.entrySet()) {
            String blockName = ForgeRegistries.BLOCKS.getKey((Object)((Block)ore.getKey())).toString();
            String blockDrops = this.buildItemDrops((Block)ore.getKey());
            this.worldGen.add(new WorldGenJson(blockName, blockDrops, WorldGenJson.BuildDistrib((HashMap)ore.getValue(), chunks_to_profile * 16), WorldGenJson.BuildRawDistrib((HashMap)ore.getValue()), dimension));
        }
        collectedData.clear();
        profiled_chunks = 0;
    }

    public boolean loadWorldGen() {
        File file = new File(JEARGHProfiler.getPath() + "/config/world-gen.json");
        if (!file.exists()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"profiling.merge.nofile"));
            return false;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            this.worldGenExisting = (List)new Gson().fromJson((Reader)br, new TypeToken<List<WorldGenJson>>(){}.getType());
            if (this.worldGenExisting == null) {
                return false;
            }
            br.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void loadMapFromWorldGen(String dimension) {
        collectedData.clear();
        for (WorldGenJson entry : this.worldGenExisting) {
            String[] distribs;
            if (!entry.dim.equals(dimension)) continue;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.block));
            for (String distrib : distribs = entry.distrib_raw.split(";")) {
                String[] gen = distrib.split(",");
                JEARGHProfilerRunnable.addToMap(block, Integer.parseInt(gen[0]), Integer.parseInt(gen[1]));
            }
        }
    }

    public void loadToWorldGen(String except_dimension) {
        for (WorldGenJson entry : this.worldGenExisting) {
            if (entry.dim.equals(except_dimension)) continue;
            this.worldGen.add(entry);
        }
    }

    public void fixIncorrectHeights(Player player, int chunk_radius_to_profile) {
        this.player = player;
        JEARGHProfiler.chunk_radius_to_profile = chunk_radius_to_profile;
        chunks_to_profile = chunk_radius_to_profile * chunk_radius_to_profile * 4;
        player.m_213846_((Component)Component.m_237115_((String)"profiling.fix"));
        this.worldGen.clear();
        dropsMap.clear();
        this.loadWorldGen();
        for (WorldGenJson entry : this.worldGenExisting) {
            if (!entry.dim.equals("minecraft:overworld")) {
                String[] distribs;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.block));
                for (String distrib : distribs = entry.distrib_raw.split(";")) {
                    String[] gen = distrib.split(",");
                    JEARGHProfilerRunnable.addToMap(block, Integer.parseInt(gen[0]) + 64, Integer.parseInt(gen[1]));
                }
                this.dumpForDimension(entry.dim);
                continue;
            }
            this.worldGen.add(entry);
        }
        player.m_213846_((Component)Component.m_237115_((String)"profiling.complete"));
        this.generateWorldGenFile();
    }

    public void start(Player player, int chunk_radius_to_profile, boolean shouldMerge) {
        shouldAbort = false;
        this.shouldMerge = shouldMerge;
        profiled_chunks = 0;
        profiled_chunks_total = 0;
        this.worldGen.clear();
        dropsMap.clear();
        JEARGHProfiler.chunk_radius_to_profile = chunk_radius_to_profile;
        this.player = player;
        new Thread(this).start();
    }

    public void abort() {
        shouldAbort = true;
        this.player.m_213846_((Component)Component.m_237115_((String)"profiling.abort.start"));
        this.executorService.shutdownNow();
        this.awaitTermination();
        this.player.m_213846_((Component)Component.m_237115_((String)"profiling.abort"));
        collectedData.clear();
        profiled_chunks = 0;
        profiled_chunks_total = 0;
    }

    private void awaitTermination() {
        block2: while (true) {
            try {
                while (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    if (!shouldAbort) continue;
                    JEARGH.LOGGER.warn("Forced shutdown!");
                    this.executorService.shutdownNow();
                    break block2;
                }
            }
            catch (InterruptedException ex) {
                JEARGH.LOGGER.warn("Interrupted!");
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        int xPosition = this.player.m_20097_().m_123341_();
        int zPosition = this.player.m_20097_().m_123343_();
        if (this.shouldMerge) {
            ServerLevel serverLevel = (ServerLevel)this.player.m_9236_();
            if (!this.loadWorldGen()) {
                return;
            }
            this.loadMapFromWorldGen(serverLevel.m_46472_().m_135782_().toString());
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.start.merge", (Object[])new Object[]{max_threads}));
            chunks_to_profile_total = chunks_to_profile = chunk_radius_to_profile * chunk_radius_to_profile * 4;
            this.executorService = Executors.newFixedThreadPool(max_threads);
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.start.dimension", (Object[])new Object[]{serverLevel.m_46472_().m_135782_(), 1, 1, chunk_radius_to_profile, chunks_to_profile}));
            for (int x = -chunk_radius_to_profile * 16 + xPosition; x < chunk_radius_to_profile * 16 + xPosition; x += 16) {
                for (int z = -chunk_radius_to_profile * 16 + zPosition; z < chunk_radius_to_profile * 16 + zPosition; z += 16) {
                    this.executorService.execute(new JEARGHProfilerRunnable(x, z, serverLevel, this.player));
                }
            }
            this.executorService.shutdown();
            this.awaitTermination();
            if (shouldAbort) {
                return;
            }
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.complete.dimension", (Object[])new Object[]{serverLevel.m_46472_().m_135782_()}));
            this.executorService = Executors.newFixedThreadPool(1);
            this.executorService.execute(new DropCalculatorRunnable(serverLevel));
            this.executorService.shutdown();
            this.awaitTermination();
            this.dumpForDimension(serverLevel.m_46472_().m_135782_().toString());
            this.loadToWorldGen(serverLevel.m_46472_().m_135782_().toString());
        } else {
            this.player.m_213846_((Component)Component.m_237110_((String)"profiling.start", (Object[])new Object[]{max_threads}));
            int dimcount = 0;
            int dimtotal = server.m_129784_().size();
            chunks_to_profile = chunk_radius_to_profile * chunk_radius_to_profile * 4;
            chunks_to_profile_total = chunks_to_profile * dimtotal;
            for (ResourceKey levelResourceKey : server.m_129784_()) {
                ServerLevel serverLevel = server.m_129880_(levelResourceKey);
                this.executorService = Executors.newFixedThreadPool(max_threads);
                this.player.m_213846_((Component)Component.m_237110_((String)"profiling.start.dimension", (Object[])new Object[]{serverLevel.m_46472_().m_135782_(), ++dimcount, dimtotal, chunk_radius_to_profile, chunks_to_profile}));
                for (int x = -chunk_radius_to_profile * 16 + xPosition; x < chunk_radius_to_profile * 16 + xPosition; x += 16) {
                    for (int z = -chunk_radius_to_profile * 16 + zPosition; z < chunk_radius_to_profile * 16 + zPosition; z += 16) {
                        this.executorService.execute(new JEARGHProfilerRunnable(x, z, serverLevel, this.player));
                    }
                }
                this.executorService.shutdown();
                this.awaitTermination();
                if (shouldAbort) {
                    return;
                }
                this.player.m_213846_((Component)Component.m_237110_((String)"profiling.complete.dimension", (Object[])new Object[]{serverLevel.m_46472_().m_135782_()}));
                this.executorService = Executors.newFixedThreadPool(1);
                this.executorService.execute(new DropCalculatorRunnable(serverLevel));
                this.executorService.shutdown();
                this.awaitTermination();
                this.dumpForDimension(serverLevel.m_46472_().m_135782_().toString());
            }
        }
        this.player.m_213846_((Component)Component.m_237115_((String)"profiling.complete"));
        this.generateWorldGenFile();
    }

    static {
        shouldAbort = false;
        collectedData = new ConcurrentHashMap<Block, HashMap<Integer, Integer>>();
        dropsMap = new ConcurrentHashMap<Block, List<ItemStackDrop>>();
    }
}

