/*
 * Decompiled with CFR 0.152.
 */
package com.cwelth.jeargh.utils;

import com.cwelth.jeargh.utils.ItemStackDrop;
import com.cwelth.jeargh.utils.JEARGHProfiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DropCalculatorRunnable
implements Runnable {
    private final ServerLevel level;
    private final RandomSource randomSource = RandomSource.m_216343_();

    public DropCalculatorRunnable(ServerLevel level) {
        this.level = level;
    }

    public List<ItemStack> getDrops(ServerLevel pLevel, BlockPos pPos, BlockState pState) {
        LootParams.Builder lootcontext$builder = new LootParams.Builder(pLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
        return pState.m_287290_(lootcontext$builder);
    }

    @Override
    public void run() {
        for (Map.Entry dropMap : JEARGHProfiler.dropsMap.entrySet()) {
            HashMap<Item, ItemStackDrop> localDrops = new HashMap<Item, ItemStackDrop>();
            BlockState blockState = null;
            BlockPos blockPos = null;
            ServerLevel serverLevel = null;
            for (ItemStackDrop stack : (List)dropMap.getValue()) {
                blockState = stack.blockState;
                blockPos = stack.blockPos;
                serverLevel = stack.serverLevel;
                if (stack.getItem() == null) continue;
                localDrops.put(stack.getItem(), stack);
            }
            int max_iterations = 1000;
            for (int i = 0; i < max_iterations; ++i) {
                List<ItemStack> drops = this.getDrops(this.level, blockPos, blockState);
                for (ItemStack itemStack : drops) {
                    Item item = itemStack.m_41720_();
                    if (!localDrops.containsKey(item)) {
                        localDrops.put(item, new ItemStackDrop(item, blockState, blockPos, serverLevel));
                    }
                    ItemStackDrop itemStackDrop = (ItemStackDrop)localDrops.get(item);
                    itemStackDrop.addDrop(itemStack.m_41613_());
                    localDrops.put(item, itemStackDrop);
                }
            }
            ArrayList<ItemStackDrop> newDropList = new ArrayList<ItemStackDrop>();
            for (Map.Entry entry : localDrops.entrySet()) {
                newDropList.add((ItemStackDrop)entry.getValue());
            }
            JEARGHProfiler.dropsMap.put((Block)dropMap.getKey(), newDropList);
        }
    }
}

