/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.api;

import com.unrealdinnerbone.jamd.api.IFeatureTypeCompact;
import com.unrealdinnerbone.trenzalore.api.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureTypeRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<IFeatureTypeCompact<?>> FEATURES = new ArrayList();

    public static void register(String modId, Supplier<IFeatureTypeCompact<?>> featureTypeCompact) {
        if (Services.PLATFORM.isModLoaded(modId)) {
            IFeatureTypeCompact<?> iFeatureTypeCompact = featureTypeCompact.get();
            LOGGER.debug("Registering Feature {} for {}", (Object)iFeatureTypeCompact.getFeatureType(), (Object)modId);
            FEATURES.add(iFeatureTypeCompact);
        } else {
            LOGGER.debug("Skipping Feature for {} as mod is not loaded", (Object)modId);
        }
    }

    public static Optional<IFeatureTypeCompact<?>> getFeatureType(String id) {
        return FEATURES.stream().filter(featureTypeCompact -> featureTypeCompact.getFeatureType().toString().equalsIgnoreCase(id)).findFirst();
    }
}

