/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import com.mojang.datafixers.util.Pair;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class FurledMapItem
extends Item {
    public static String FURLED_MAP_NBT = "furledMapData";
    public static String FURLED_MAP_LOCATION = "destination";
    public static String FURLED_MAP_DESCRIPTION = "description";

    public FurledMapItem() {
        super(ItemPropertiesHelper.material().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            ItemStack itemStack = player.m_21120_(hand);
            CompoundTag tag = itemStack.m_41783_();
            level.m_6269_(null, (Entity)player, SoundEvents.f_12493_, player.m_5720_(), 1.0f, 1.0f);
            player.m_36335_().m_41524_((Item)ItemRegistry.FURLED_MAP.get(), 50);
            if (tag != null && tag.m_128425_(FURLED_MAP_NBT, 10) && tag.m_128469_(FURLED_MAP_NBT).m_128441_(FURLED_MAP_LOCATION)) {
                Pair pair;
                ResourceLocation destinationResource = new ResourceLocation(tag.m_128469_(FURLED_MAP_NBT).m_128461_(FURLED_MAP_LOCATION));
                ResourceKey structureResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)destinationResource);
                Optional<HolderSet.Direct> holder = serverlevel.m_9598_().m_175515_(Registries.f_256944_).m_203636_(structureResourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0}));
                if (holder.isPresent() && (pair = serverlevel.m_7726_().m_8481_().m_223037_(serverlevel, (HolderSet)holder.get(), player.m_20183_(), 100, ((Boolean)ServerConfigs.FURLED_MAPS_SKIP_CHUNKS.get()).booleanValue())) != null) {
                    BlockPos blockpos = (BlockPos)pair.getFirst();
                    ItemStack mapStack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)mapStack);
                    MapItemSavedData.m_77925_((ItemStack)mapStack, (BlockPos)blockpos, (String)"x", (MapDecoration.Type)MapDecoration.Type.RED_X);
                    if (tag.m_128469_(FURLED_MAP_NBT).m_128441_(FURLED_MAP_DESCRIPTION)) {
                        MutableComponent mapTitle = Component.Serializer.m_130701_((String)tag.m_128469_(FURLED_MAP_NBT).m_128461_(FURLED_MAP_DESCRIPTION));
                        mapStack.m_41714_((Component)mapTitle);
                    }
                    FurledMapItem.replaceItem(player, mapStack, hand);
                    return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
                }
            }
            FurledMapItem.replaceItem(player, new ItemStack((ItemLike)Items.f_42676_), hand);
        }
        return super.m_7203_(level, player, hand);
    }

    private static void replaceItem(Player player, ItemStack itemStack, InteractionHand hand) {
        boolean flag = player.m_150110_().f_35937_;
        if (!flag) {
            player.m_21008_(hand, itemStack);
        } else {
            player.m_150109_().m_36054_(itemStack);
        }
    }

    public static ItemStack of(ResourceLocation structure, MutableComponent descriptor) {
        ItemStack itemStack = new ItemStack((ItemLike)ItemRegistry.FURLED_MAP.get());
        itemStack.m_41698_(FURLED_MAP_NBT).m_128359_(FURLED_MAP_LOCATION, structure.toString());
        itemStack.m_41698_(FURLED_MAP_NBT).m_128359_(FURLED_MAP_DESCRIPTION, Component.Serializer.m_130703_((Component)descriptor));
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237110_((String)"item.irons_spellbooks.furled_map_descriptor_framing", (Object[])new Object[]{descriptor}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)))));
        itemStack.m_41698_("display").m_128365_("Lore", (Tag)lore);
        return itemStack;
    }
}

