/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.util.capability;

import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.minecraftforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    private boolean canExtract = true;
    private boolean canReceive = true;
    private BlockEntitySyncable blockEntity;

    public CustomEnergyStorage(int capacity) {
        super(capacity, capacity, capacity);
    }

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract, int passEnergy) {
        super(capacity, maxReceive, maxExtract, passEnergy);
    }

    public CustomEnergyStorage setBlockEntity(BlockEntitySyncable entity) {
        this.blockEntity = entity;
        return this;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived > 0) {
            this.onEnergyChange();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted > 0) {
            this.onEnergyChange();
        }
        return energyExtracted;
    }

    public void onEnergyChange() {
        if (this.blockEntity != null) {
            this.blockEntity.sync();
        }
    }

    public boolean canExtract() {
        return this.canExtract && super.canExtract();
    }

    public boolean canReceive() {
        return this.canReceive && super.canReceive();
    }

    public CustomEnergyStorage noExtraction() {
        this.canExtract = false;
        return this;
    }

    public CustomEnergyStorage noReceive() {
        this.canReceive = false;
        return this;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.capacity = maxCapacity;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int addEnergy(int maxReceive) {
        return this.addEnergy(maxReceive, false);
    }

    public int addEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
            this.onEnergyChange();
        }
        return energyReceived;
    }

    public int subtractEnergy(int maxExtract) {
        return this.subtractEnergy(maxExtract, false);
    }

    public int subtractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
            this.onEnergyChange();
        }
        return energyExtracted;
    }
}

